/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.MethodEggg;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Destroy;
import org.noear.solon.annotation.Init;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeanWrapLifecycle
implements LifecycleBean {
    static final Logger log = LoggerFactory.getLogger(BeanWrapLifecycle.class);
    private BeanWrap bw;
    private MethodEggg initMethod;
    private String initMethodName;
    private int initIndex;
    private MethodEggg destroyMethod;
    private String destroyMethodName;

    public BeanWrapLifecycle(BeanWrap bw, String initMethodName, String destroyMethodName) {
        this.bw = bw;
        this.initMethodName = initMethodName;
        this.destroyMethodName = destroyMethodName;
    }

    public Method initMethod() {
        if (this.initMethod == null) {
            return null;
        }
        return this.initMethod.getMethod();
    }

    public Method destroyMethod() {
        if (this.destroyMethod == null) {
            return null;
        }
        return this.destroyMethod.getMethod();
    }

    public boolean check() {
        boolean isOk;
        if (this.bw.raw() == null) {
            return false;
        }
        ClassEggg clzEggg = this.bw.rawEggg();
        try {
            if (Utils.isNotEmpty(this.initMethodName)) {
                this.initMethod = clzEggg.findMethodEggg(this.initMethodName, new Class[0]);
            }
            if (Utils.isNotEmpty(this.destroyMethodName)) {
                this.destroyMethod = clzEggg.findMethodEggg(this.destroyMethodName, new Class[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.initMethod == null && this.destroyMethod == null && !clzEggg.getTypeEggg().isJdkType()) {
            for (MethodEggg m : clzEggg.getOwnMethodEgggs()) {
                Init initAnno = m.getMethod().getAnnotation(Init.class);
                if (initAnno != null) {
                    if (m.getParamCount() == 0) {
                        this.initMethod = m;
                        ClassUtil.accessibleAsTrue(m.getMethod());
                        this.initIndex = initAnno.index();
                    }
                } else {
                    Destroy destroyAnno = m.getMethod().getAnnotation(Destroy.class);
                    if (destroyAnno != null && m.getParamCount() == 0) {
                        this.destroyMethod = m;
                        ClassUtil.accessibleAsTrue(this.destroyMethod.getMethod());
                    }
                }
                if (this.initMethod == null || this.destroyMethod == null) continue;
                break;
            }
        }
        if (this.initMethod != null && this.initIndex == 0) {
            this.initIndex = IndexUtil.buildLifecycleIndex(this.bw.rawClz());
        }
        boolean bl = isOk = this.initMethod != null || this.destroyMethod != null;
        if (isOk && this.bw.raw() instanceof LifecycleBean) {
            log.warn("LifecycleBean not support @Init & @Destroy, class=" + this.bw.rawClz().getName());
            return false;
        }
        return isOk;
    }

    public int index() {
        return this.initIndex;
    }

    @Override
    public void start() throws Throwable {
        if (this.initMethod != null) {
            try {
                this.initMethod.invoke(this.bw.raw(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                throw Utils.throwableUnwrap(e2);
            }
        }
    }

    @Override
    public void stop() throws Throwable {
        if (this.destroyMethod != null) {
            try {
                this.destroyMethod.invoke(this.bw.raw(), new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                throw Utils.throwableUnwrap(e2);
            }
        }
    }
}

