/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.eggg.GenericResolver;
import org.noear.solon.core.util.Assert;

public class GenericUtil {
    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        for (Type supIfc : GenericUtil.getGenericInterfaces(clazz)) {
            Class<?>[] classes;
            if (supIfc instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)supIfc;
                Class rawClz = (Class)type.getRawType();
                if (rawClz != genericIfc && !GenericUtil.getDeepGenericInterfaces(rawClz).contains(genericIfc)) continue;
                return (Class[])Arrays.stream(type.getActualTypeArguments()).filter(item -> item instanceof Class).map(item -> (Class)item).toArray(Class[]::new);
            }
            if (!(supIfc instanceof Class) || (classes = GenericUtil.resolveTypeArguments((Class)supIfc, genericIfc)) == null) continue;
            return classes;
        }
        Type supClz = GenericUtil.getGenericSuperclass(clazz);
        if (supClz instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)supClz;
            return (Class[])Arrays.stream(type.getActualTypeArguments()).filter(item -> item instanceof Class).map(item -> (Class)item).toArray(Class[]::new);
        }
        return null;
    }

    public static ParameterizedType toParameterizedType(Type type) throws RuntimeException {
        return GenericUtil.toParameterizedType(type, null);
    }

    public static ParameterizedType toParameterizedType(Type type, Map<String, Type> genericInfo) throws RuntimeException {
        if (type == null) {
            return null;
        }
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
            if (!Assert.isEmpty(genericInfo)) {
                boolean typeArgsChanged = false;
                Type[] typeArgs = result.getActualTypeArguments();
                Class rawClz = (Class)result.getRawType();
                for (int i = 0; i < typeArgs.length; ++i) {
                    Type typeArg1 = typeArgs[i];
                    if (!(typeArg1 instanceof TypeVariable) || (typeArg1 = genericInfo.get(typeArg1.getTypeName())) == null) continue;
                    typeArgsChanged = true;
                    typeArgs[i] = typeArg1;
                }
                if (typeArgsChanged) {
                    result = new GenericResolver.ParameterizedTypeImpl(rawClz, typeArgs, result.getOwnerType());
                }
            }
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = GenericUtil.getGenericSuperclass(clazz);
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = GenericUtil.getGenericInterfaces(clazz)) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = GenericUtil.toParameterizedType(genericSuper, genericInfo);
        }
        return result;
    }

    public static Map<String, Type> getGenericInfo(Type type) {
        return GenericResolver.getDefault().getGenericInfo(type);
    }

    public static Type reviewType(Type type, Type genericInfo) {
        if (type instanceof TypeVariable || type instanceof ParameterizedType) {
            return GenericUtil.reviewType(type, GenericUtil.getGenericInfo(genericInfo));
        }
        return type;
    }

    public static Type reviewType(Type type, Map<String, Type> genericInfo) {
        return GenericResolver.getDefault().reviewType(type, genericInfo);
    }

    public static boolean genericMatched(ParameterizedType checkType, ParameterizedType sourceType) {
        if (sourceType.getActualTypeArguments().length == checkType.getActualTypeArguments().length) {
            if (sourceType.getTypeName().equals(checkType.getTypeName())) {
                return true;
            }
            if (sourceType.getRawType().equals(checkType.getRawType())) {
                Type[] typesC = checkType.getActualTypeArguments();
                Type[] typesS = sourceType.getActualTypeArguments();
                boolean isOk = true;
                for (int i = 0; i < typesC.length; ++i) {
                    Type c1 = typesC[i];
                    Type s1 = typesS[i];
                    if (c1 instanceof Class) {
                        isOk = c1.equals(s1);
                    } else if (c1 instanceof ParameterizedType) {
                        isOk = s1 instanceof ParameterizedType ? GenericUtil.genericMatched((ParameterizedType)c1, (ParameterizedType)s1) : false;
                    } else if (c1 instanceof GenericArrayType) {
                        isOk = c1.equals(s1);
                    } else if (c1 instanceof WildcardType) {
                        Type s2;
                        if (s1 instanceof Class) {
                            isOk = GenericUtil.wildcardMatched((WildcardType)c1, (Class)s1);
                        } else if (s1 instanceof ParameterizedType && (s2 = ((ParameterizedType)s1).getRawType()) instanceof Class) {
                            isOk = GenericUtil.wildcardMatched((WildcardType)c1, (Class)s2);
                        }
                    } else {
                        isOk = false;
                    }
                    if (!isOk) break;
                }
                if (isOk) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean wildcardMatched(WildcardType w1, Class<?> s1) {
        for (Type b1 : w1.getUpperBounds()) {
            if (!(b1 instanceof Class) || ((Class)b1).isAssignableFrom(s1)) continue;
            return false;
        }
        for (Type b1 : w1.getLowerBounds()) {
            if (!(b1 instanceof Class) || s1.isAssignableFrom((Class)b1)) continue;
            return false;
        }
        return true;
    }

    private static Type getGenericSuperclass(Class<?> clazz) throws RuntimeException {
        return clazz.getGenericSuperclass();
    }

    private static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    private static List<Class<?>> getDeepGenericInterfaces(Class<?> clazz) {
        return GenericUtil.getDeepGenericInterfaces(clazz, new ArrayList());
    }

    private static List<Class<?>> getDeepGenericInterfaces(Class<?> clazz, List<Class<?>> classes) {
        for (Type supIfc : GenericUtil.getGenericInterfaces(clazz)) {
            if (!(supIfc instanceof ParameterizedType)) continue;
            Class rawClz = (Class)((ParameterizedType)supIfc).getRawType();
            classes.add(rawClz);
            GenericUtil.getDeepGenericInterfaces(rawClz, classes);
        }
        return classes;
    }
}

