/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.noear.solon.SolonApp;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.handle.ActionArgumentResolver;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextPathFilter;
import org.noear.solon.core.handle.EntityConverter;
import org.noear.solon.core.handle.EntityConverter2Executor;
import org.noear.solon.core.handle.EntityConverter2Renderer;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.ReturnValueHandler;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateEmpty;
import org.noear.solon.core.handle.SessionStateFactory;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorLimiter;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final SolonApp app;
    private final Set<Class<?>> typeSet = new HashSet();
    private final List<RankEntity<Filter>> filterNodes = new ArrayList<RankEntity<Filter>>();
    private ContextPathFilter contextPathFilter;
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private final List<RankEntity<RouterInterceptor>> interceptorNodes = new ArrayList<RankEntity<RouterInterceptor>>();
    private final List<RankEntity<ReturnValueHandler>> returnHandlers = new ArrayList<RankEntity<ReturnValueHandler>>();
    private ActionExecuteHandler executeHandlerDefault;
    private List<RankEntity<ActionExecuteHandler>> executeHandlers = new ArrayList<RankEntity<ActionExecuteHandler>>();
    private List<RankEntity<ActionArgumentResolver>> argumentResolvers = new ArrayList<RankEntity<ActionArgumentResolver>>();
    private SessionStateFactory _sessionStateFactory = ctx -> new SessionStateEmpty();
    private boolean _sessionStateUpdated;

    public ChainManager(SolonApp app) {
        this.app = app;
    }

    public Collection<Filter> getFilterNodes() {
        ArrayList<Filter> tmp = new ArrayList<Filter>();
        for (RankEntity<Filter> entity : this.filterNodes) {
            tmp.add((Filter)entity.target);
        }
        return tmp;
    }

    public void addFilter(Filter filter, int index) {
        if (filter instanceof ContextPathFilter) {
            this.contextPathFilter = (ContextPathFilter)filter;
            return;
        }
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity<Filter>(filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addFilterIfAbsent(Filter filter, int index) {
        if (filter instanceof ContextPathFilter) {
            this.contextPathFilter = (ContextPathFilter)filter;
            return;
        }
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(filter.getClass())) {
                return;
            }
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity<Filter>(filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void doFilter(Context x, Handler lastHandler) throws Throwable {
        if (this.contextPathFilter == null) {
            new FilterChainImpl(this.filterNodes, lastHandler).doFilter(x);
        } else {
            this.contextPathFilter.doFilter(x, new FilterChainImpl(this.filterNodes, lastHandler));
        }
    }

    public Collection<RouterInterceptor> getInterceptorNodes() {
        ArrayList<RouterInterceptor> tmp = new ArrayList<RouterInterceptor>();
        for (RankEntity<RouterInterceptor> entity : this.interceptorNodes) {
            if (entity.target instanceof RouterInterceptorLimiter) {
                tmp.add(((RouterInterceptorLimiter)entity.target).getInterceptor());
                continue;
            }
            tmp.add((RouterInterceptor)entity.target);
        }
        return tmp;
    }

    public void addInterceptor(RouterInterceptor interceptor, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(interceptor.getClass());
            interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
            this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
            this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addInterceptorIfAbsent(RouterInterceptor interceptor, int index) {
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(interceptor.getClass())) {
                return;
            }
            this.typeSet.add(interceptor.getClass());
            interceptor = new RouterInterceptorLimiter(interceptor, interceptor.pathPatterns());
            this.interceptorNodes.add(new RankEntity<RouterInterceptor>(interceptor, index));
            this.interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public <T extends RouterInterceptor> void removeInterceptor(Class<T> clz) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(clz);
            this.interceptorNodes.removeIf(i -> {
                if (i.target instanceof RouterInterceptorLimiter) {
                    return ((RouterInterceptorLimiter)i.target).getInterceptor().getClass() == clz;
                }
                return ((RouterInterceptor)i.target).getClass() == clz;
            });
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void doIntercept(Context x, Handler mainHandler, Handler lastHandler) throws Throwable {
        new RouterInterceptorChainImpl(this.interceptorNodes, lastHandler).doIntercept(x, mainHandler);
    }

    public void postArguments(Context x, ParamWrap[] args, Object[] vals) throws Throwable {
        for (int i = this.interceptorNodes.size() - 1; i >= 0; --i) {
            RankEntity<RouterInterceptor> e = this.interceptorNodes.get(i);
            ((RouterInterceptor)e.target).postArguments(x, args, vals);
        }
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (int i = this.interceptorNodes.size() - 1; i >= 0; --i) {
            RankEntity<RouterInterceptor> e = this.interceptorNodes.get(i);
            result = ((RouterInterceptor)e.target).postResult(x, result);
        }
        return result;
    }

    public void addReturnHandler(ReturnValueHandler e) {
        this.addReturnHandler(e, 0);
    }

    public void addReturnHandler(ReturnValueHandler e, int index) {
        this.returnHandlers.add(new RankEntity<ReturnValueHandler>(e, index));
        Collections.sort(this.returnHandlers);
    }

    public ReturnValueHandler getReturnHandler(Context ctx, Class<?> returnType) {
        for (RankEntity<ReturnValueHandler> entity : this.returnHandlers) {
            if (!((ReturnValueHandler)entity.target).matched(ctx, returnType)) continue;
            return (ReturnValueHandler)entity.target;
        }
        return null;
    }

    public void defExecuteHandler(ActionExecuteHandler e) {
        if (e != null) {
            this.executeHandlerDefault = e;
        }
    }

    public void addExecuteHandler(ActionExecuteHandler e) {
        this.addExecuteHandler(e, 0);
    }

    public void addExecuteHandler(ActionExecuteHandler e, int index) {
        if (e != null) {
            this.executeHandlers.add(new RankEntity<ActionExecuteHandler>(e, index));
            Collections.sort(this.executeHandlers);
        }
    }

    public void removeExecuteHandler(Class<?> clz) {
        this.executeHandlers.removeIf(e -> clz.isInstance(e.target));
    }

    public void removeExecuteHandler(Predicate<ActionExecuteHandler> condition) {
        this.executeHandlers.removeIf(e -> condition.test((ActionExecuteHandler)e.target));
    }

    public ActionExecuteHandler getExecuteHandler(Context c, int paramSize) {
        String ct = c.contentType();
        if (paramSize > 0) {
            for (RankEntity<ActionExecuteHandler> me : this.executeHandlers) {
                if (!((ActionExecuteHandler)me.target).matched(c, ct)) continue;
                return (ActionExecuteHandler)me.target;
            }
        }
        return this.getExecuteHandlerDefault();
    }

    public ActionExecuteHandler getExecuteHandlerDefault() {
        if (this.executeHandlerDefault == null) {
            return FactoryManager.getGlobal().mvcFactory().getExecuteHandlerDefault();
        }
        return this.executeHandlerDefault;
    }

    public void addArgumentResolver(ActionArgumentResolver e) {
        this.addArgumentResolver(e, 0);
    }

    public void addArgumentResolver(ActionArgumentResolver e, int index) {
        if (e != null) {
            this.argumentResolvers.add(new RankEntity<ActionArgumentResolver>(e, index));
            Collections.sort(this.argumentResolvers);
        }
    }

    public void removeArgumentResolver(Class<?> clz) {
        this.argumentResolvers.removeIf(e -> clz.isInstance(e.target));
    }

    public ActionArgumentResolver getArgumentResolver(Context ctx, ParamWrap pWrap) {
        for (RankEntity<ActionArgumentResolver> me : this.argumentResolvers) {
            if (!((ActionArgumentResolver)me.target).matched(ctx, pWrap)) continue;
            return (ActionArgumentResolver)me.target;
        }
        return null;
    }

    public SessionStateFactory getSessionStateFactory() {
        return this._sessionStateFactory;
    }

    public void setSessionStateFactory(SessionStateFactory ssf) {
        if (ssf != null) {
            this._sessionStateFactory = ssf;
            this._sessionStateUpdated = true;
        }
    }

    public void refreshSessionState(Context c) throws IOException {
        if (this._sessionStateUpdated) {
            c.sessionState().sessionRefresh();
        }
    }

    public SessionState getSessionState(Context ctx) {
        return this._sessionStateFactory.create(ctx);
    }

    public void addEntityConverter(EntityConverter e) {
        this.addEntityConverter(e, 0);
    }

    public void addEntityConverter(EntityConverter e, int index) {
        if (e != null) {
            this.addExecuteHandler(new EntityConverter2Executor(e), index);
            if (e.mappings() != null) {
                EntityConverter2Renderer render = new EntityConverter2Renderer(e);
                for (String mapping : e.mappings()) {
                    this.app.renders().register(mapping, render);
                }
            }
        }
    }
}

