/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.URI;
import org.noear.solon.Solon;

@FunctionalInterface
public interface LoadBalance {
    public static final String URI_SCHEME = "lb";

    public static LoadBalance parse(String uriStr) {
        if (uriStr.contains("://")) {
            return LoadBalance.parse(URI.create(uriStr));
        }
        return LoadBalance.get(uriStr);
    }

    public static LoadBalance parse(URI uri) {
        if (URI_SCHEME.equals(uri.getScheme())) {
            return new LoadBalanceWrap(null, LoadBalance.get(uri.getHost()), uri.getPort());
        }
        return new LoadBalanceWrap(uri.getScheme() + "://" + uri.getAuthority(), null, -1);
    }

    public static LoadBalance get(String service) {
        return LoadBalance.get("", service);
    }

    public static LoadBalance get(String group, String service) {
        return Solon.app().factoryManager().newLoadBalance(group, service);
    }

    default public String getServer() {
        return this.getServer(0);
    }

    public String getServer(int var1);

    public static class LoadBalanceWrap
    implements LoadBalance {
        private String server0;
        private LoadBalance lb0;
        private int port0;

        public LoadBalanceWrap(String server, LoadBalance lb, int port) {
            this.server0 = server;
            this.lb0 = lb;
            this.port0 = port;
        }

        @Override
        public String getServer(int port) {
            if (this.server0 == null) {
                if (this.lb0 == null) {
                    return null;
                }
                if (this.port0 > 0) {
                    return this.lb0.getServer(this.port0);
                }
                return this.lb0.getServer(port);
            }
            return this.server0;
        }
    }

    public static interface Factory {
        public LoadBalance create(String var1, String var2);
    }
}

