/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ParameterizedTypeImpl;

public class GenericUtil {
    private static final Map<Type, Map<String, Type>> genericInfoCached = new ConcurrentHashMap<Type, Map<String, Type>>();

    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        for (Type supIfc : clazz.getGenericInterfaces()) {
            Class<?>[] classes;
            if (supIfc instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)supIfc;
                Class rawClz = (Class)type.getRawType();
                if (rawClz != genericIfc && !GenericUtil.getGenericInterfaces(rawClz).contains(genericIfc)) continue;
                return (Class[])Arrays.stream(type.getActualTypeArguments()).filter(item -> item instanceof Class).map(item -> (Class)item).toArray(Class[]::new);
            }
            if (!(supIfc instanceof Class) || (classes = GenericUtil.resolveTypeArguments((Class)supIfc, genericIfc)) == null) continue;
            return classes;
        }
        Type supClz = clazz.getGenericSuperclass();
        if (supClz instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)supClz;
            return (Class[])Arrays.stream(type.getActualTypeArguments()).filter(item -> item instanceof Class).map(item -> (Class)item).toArray(Class[]::new);
        }
        return null;
    }

    private static List<Class<?>> getGenericInterfaces(Class<?> clazz) {
        return GenericUtil.getGenericInterfaces(clazz, new ArrayList());
    }

    private static List<Class<?>> getGenericInterfaces(Class<?> clazz, List<Class<?>> classes) {
        for (Type supIfc : clazz.getGenericInterfaces()) {
            if (!(supIfc instanceof ParameterizedType)) continue;
            Class rawClz = (Class)((ParameterizedType)supIfc).getRawType();
            classes.add(rawClz);
            GenericUtil.getGenericInterfaces(rawClz, classes);
        }
        return classes;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        return GenericUtil.toParameterizedType(type, null);
    }

    public static ParameterizedType toParameterizedType(Type type, Map<String, Type> genericInfo) {
        if (type == null) {
            return null;
        }
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
            if (!Utils.isEmpty(genericInfo)) {
                boolean typeArgsChanged = false;
                Type[] typeArgs = result.getActualTypeArguments();
                Class rawClz = (Class)result.getRawType();
                for (int i = 0; i < typeArgs.length; ++i) {
                    Type typeArg1 = typeArgs[i];
                    if (!(typeArg1 instanceof TypeVariable) || (typeArg1 = genericInfo.get(typeArg1.getTypeName())) == null) continue;
                    typeArgsChanged = true;
                    typeArgs[i] = typeArg1;
                }
                if (typeArgsChanged) {
                    result = new ParameterizedTypeImpl(rawClz, typeArgs, result.getOwnerType());
                }
            }
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = GenericUtil.toParameterizedType(genericSuper, genericInfo);
        }
        return result;
    }

    public static Map<String, Type> getGenericInfo(Type type) {
        return genericInfoCached.computeIfAbsent(type, k -> GenericUtil.createTypeGenericMap(k));
    }

    private static Map<String, Type> createTypeGenericMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        while (null != type && null != (parameterizedType = GenericUtil.toParameterizedType(type, typeMap))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable || !GenericUtil.checkNoTypeVariable(value)) continue;
                typeMap.put(typeParameters[i].getTypeName(), value);
            }
            type = rawType;
        }
        return typeMap;
    }

    private static boolean checkNoTypeVariable(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type rawType : parameterizedType.getActualTypeArguments()) {
                if (!(rawType instanceof TypeVariable)) continue;
                return false;
            }
        }
        return true;
    }

    public static Type reviewType(Type type, Type genericInfo) {
        if (type instanceof TypeVariable || type instanceof ParameterizedType) {
            return GenericUtil.reviewType(type, GenericUtil.getGenericInfo(genericInfo));
        }
        return type;
    }

    public static Type reviewType(Type type, Map<String, Type> genericInfo) {
        if (genericInfo == null || genericInfo.isEmpty()) {
            return type;
        }
        if (type instanceof TypeVariable) {
            Type typeTmp = genericInfo.get(type.getTypeName());
            if (typeTmp == null) {
                return type;
            }
            return GenericUtil.reviewType(typeTmp, genericInfo);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType typeTmp = (ParameterizedType)type;
            Type[] typeArgs = typeTmp.getActualTypeArguments();
            boolean typeChanged = false;
            for (int i = 0; i < typeArgs.length; ++i) {
                Type t1 = typeArgs[i];
                typeArgs[i] = GenericUtil.reviewType(t1, genericInfo);
                if (typeArgs[i] == t1) continue;
                typeChanged = true;
            }
            if (typeChanged) {
                return new ParameterizedTypeImpl((Class)typeTmp.getRawType(), typeArgs, typeTmp.getOwnerType());
            }
            return type;
        }
        return type;
    }
}

