/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.function.Supplier;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.lang.Nullable;

public class VarHolderOfField
implements VarHolder {
    private final FieldWrap fw;
    private final Object obj;
    private final AppContext ctx;
    private Class<?> dependencyType;
    private Object val;
    private Supplier valDef;
    private boolean required = false;
    private boolean done;
    private InjectGather gather;

    public VarHolderOfField(AppContext ctx, FieldWrap fw, Object obj, InjectGather gather) {
        this.ctx = ctx;
        this.fw = fw;
        this.obj = obj;
        this.gather = gather;
    }

    @Override
    public AppContext context() {
        return this.ctx;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    @Nullable
    public ParameterizedType getGenericType() {
        return this.fw.getGenericType();
    }

    @Override
    public Class<?> getDependencyType() {
        if (this.dependencyType == null) {
            return this.getType();
        }
        return this.dependencyType;
    }

    @Override
    public void setDependencyType(Class<?> dependencyType) {
        this.dependencyType = dependencyType;
    }

    @Override
    public Class<?> getType() {
        return this.fw.getType();
    }

    @Override
    public Annotation[] getAnnoS() {
        return this.fw.getAnnoS();
    }

    @Override
    public String getFullName() {
        Class<?> declClz;
        Class<?> fileClz = declClz = this.fw.getField().getDeclaringClass();
        if (declClz.isMemberClass()) {
            fileClz = declClz.getEnclosingClass();
        }
        StringBuilder buf = new StringBuilder();
        buf.append("'").append(this.fw.getName()).append("'");
        buf.append("\r\n\tat ").append(declClz.getName()).append(".").append(this.fw.getName()).append("(").append(fileClz.getSimpleName()).append(".java:0)");
        if (declClz != this.fw.getOwnerClz()) {
            buf.append("\r\n\tat ").append(this.fw.getOwnerClz().getName());
        }
        return buf.toString();
    }

    @Override
    public void setValue(Object val) {
        if (val != null) {
            this.fw.setValue(this.obj, val, true);
            this.ctx.aot().registerJdkProxyType(this.getType(), val);
        }
        this.val = val;
        this.done = true;
        if (this.gather != null) {
            this.gather.run();
        }
    }

    @Override
    public void setValueDefault(Supplier supplier) {
        this.valDef = supplier;
    }

    @Override
    public Object getValue() {
        if (this.val == null && this.valDef != null) {
            return this.valDef.get();
        }
        return this.val;
    }

    @Override
    public void commit() {
        Object tmp;
        if (this.isDone()) {
            return;
        }
        if (this.valDef != null && (tmp = this.valDef.get()) != null) {
            this.setValue(tmp);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public void required(boolean required) {
        this.required = required;
    }

    public String toString() {
        if (this.fw.getGenericType() == null) {
            return this.fw.getName() + ":" + this.fw.getType().getTypeName();
        }
        return this.fw.getName() + ":" + this.fw.getGenericType().getTypeName();
    }
}

