/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.exception.InjectionException;
import org.noear.solon.core.util.ConsumerEx;

public class InjectGather
implements Runnable,
Comparable<InjectGather> {
    private List<VarHolder> vars;
    private int varSize;
    private boolean done;
    private ConsumerEx<Object[]> onDone;
    private boolean requireRun;
    private Class<?> outType;
    private int label;
    public int index;

    public InjectGather(int label, Class<?> outType, boolean requireRun, int varSize, ConsumerEx<Object[]> onDone) {
        this.requireRun = requireRun;
        this.label = label;
        this.onDone = onDone;
        this.varSize = varSize;
        this.vars = new ArrayList<VarHolder>(varSize);
        this.outType = outType;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isMethod() {
        return this.label == 1;
    }

    public Class<?> getOutType() {
        return this.outType;
    }

    public List<VarHolder> getVars() {
        return this.vars;
    }

    public void add(VarHolder p) {
        this.vars.add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            Utils.locker().lock();
            try {
                if (this.done) {
                    return;
                }
                for (VarHolder varHolder : this.vars) {
                    if (varHolder.isDone()) continue;
                    return;
                }
                if (this.vars.size() != this.varSize) {
                    return;
                }
                this.done = true;
                if (this.onDone == null) break block12;
                ArrayList<Object> args = new ArrayList<Object>(this.vars.size());
                for (VarHolder p1 : this.vars) {
                    args.add(p1.getValue());
                }
                try {
                    this.onDone.accept(args.toArray());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
    }

    public void commit() {
        for (VarHolder p1 : this.vars) {
            p1.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws Throwable {
        Utils.locker().lock();
        try {
            if (this.done) {
                return;
            }
            if (this.vars.size() != this.varSize) {
                return;
            }
            for (VarHolder p1 : this.vars) {
                p1.commit();
                if (p1.isDone() || !p1.required()) continue;
                if (this.label == 1) {
                    throw new InjectionException("Method param injection failed: " + p1.getFullName());
                }
                if (this.label == 2) {
                    throw new InjectionException("Constructor param injection failed: " + p1.getFullName());
                }
                throw new InjectionException("Field injection failed: " + p1.getFullName());
            }
            if (this.onDone != null && this.requireRun) {
                ArrayList<Object> args = new ArrayList<Object>(this.vars.size());
                for (VarHolder p1 : this.vars) {
                    args.add(p1.getValue());
                }
                this.done = true;
                this.onDone.accept(args.toArray());
            }
        }
        finally {
            Utils.locker().unlock();
        }
    }

    @Override
    public int compareTo(InjectGather o) {
        if (this.index == o.index) {
            return 0;
        }
        if (this.index < o.index) {
            return -1;
        }
        return 1;
    }
}

