/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.mvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Consumes;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Produces;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.MethodWrap;

public class ActionDefault
extends HandlerAide
implements Action {
    private final BeanWrap bWrap;
    private final HandlerAide bAide;
    private Render bRender;
    private final MethodWrap mWrap;
    private String mProduces;
    private String mConsumes;
    private final String mName;
    private final String mFullName;
    private final boolean mRemoting;
    private final Mapping mMapping;
    private boolean mMultipart;
    private PathAnalyzer pathKeysAnalyzer;
    private List<String> pathKeys;

    public ActionDefault(BeanWrap bWrap, Method method) {
        this(bWrap, null, method, null, null, false, null);
    }

    public ActionDefault(BeanWrap bWrap, HandlerAide bAide, Method method, Mapping mapping, String path, boolean remoting, Render render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        method.setAccessible(true);
        if (NativeDetector.isAotRuntime()) {
            bWrap.context().methodGet(bWrap.rawClz(), method);
        }
        this.mWrap = new MethodWrap(bWrap.context(), bWrap.rawClz(), method, GenericUtil.getGenericInfo(bWrap.clz()));
        this.mRemoting = remoting;
        this.mMapping = mapping;
        this.bRender = render;
        if (this.bRender == null && Render.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (Render)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
        } else {
            Object producesAnno = method.getAnnotation(Produces.class);
            Consumes consumesAnno = method.getAnnotation(Consumes.class);
            this.mProduces = producesAnno == null ? mapping.produces() : producesAnno.value();
            this.mConsumes = consumesAnno == null ? mapping.consumes() : consumesAnno.value();
            if (Utils.isEmpty(this.mProduces) && (producesAnno = bWrap.rawClz().getAnnotation(Produces.class)) != null) {
                this.mProduces = producesAnno.value();
            }
            if (Utils.isEmpty(this.mConsumes) && (consumesAnno = bWrap.rawClz().getAnnotation(Consumes.class)) != null) {
                this.mConsumes = consumesAnno.value();
            }
            this.mMultipart = mapping.multipart();
            this.mName = Utils.annoAlias(mapping.value(), mapping.path());
        }
        this.mFullName = Utils.isEmpty(path) ? this.mName : (path.startsWith("/") ? path.substring(1) : path);
        if (!this.mMultipart) {
            for (Class<?> clz : method.getParameterTypes()) {
                if (!UploadedFile.class.isAssignableFrom(clz)) continue;
                this.mMultipart = true;
            }
        }
        if (path != null && path.contains("{")) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathKeysAnalyzer = PathAnalyzer.get(path);
            }
        }
    }

    @Override
    public String name() {
        return this.mName;
    }

    @Override
    public String fullName() {
        return this.mFullName;
    }

    @Override
    public Mapping mapping() {
        return this.mMapping;
    }

    @Override
    public MethodWrap method() {
        return this.mWrap;
    }

    @Override
    public BeanWrap controller() {
        return this.bWrap;
    }

    @Override
    public String produces() {
        return this.mProduces;
    }

    @Override
    public String consumes() {
        return this.mConsumes;
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (Utils.isNotEmpty(this.mConsumes) && (x.contentType() == null || !x.contentType().contains(this.mConsumes))) {
            throw new StatusException("Unsupported Media Type, path=" + x.path(), 415);
        }
        if (this.mMultipart) {
            x.autoMultipart(true);
        }
        if (this.bAide == null) {
            this.actionFilterDo(x);
        } else {
            new FilterChainImpl(this.bAide.filters(), this::actionFilterDo).doFilter(x);
        }
    }

    protected void actionFilterDo(Context x) throws Throwable {
        new FilterChainImpl(this.filters(), this::actionHandleDo).doFilter(x);
    }

    protected void actionHandleDo(Context x) throws Throwable {
        this.invoke(x, null);
    }

    @Override
    public void invoke(Context c, Object obj) throws Throwable {
        c.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get(true);
            }
            c.attrSet("controller", obj);
            c.attrSet("action", this);
            this.invoke0(c, obj);
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            this.renderDo(e, c);
        }
    }

    protected void invoke0(Context c, Object obj) throws Throwable {
        try {
            if (!c.getHandled()) {
                this.bindPathVarDo(c);
                c.result = this.executeDo(c, obj);
                if (Utils.isEmpty(this.mProduces)) {
                    String tmp = c.accept();
                    if (c.contentTypeNew() == null && tmp != null && tmp.indexOf(44) < 0) {
                        c.contentType(tmp);
                    }
                } else {
                    c.accept(this.mProduces);
                    c.contentType(this.mProduces);
                }
                ActionReturnHandler returnHandler = Solon.app().chainManager().getReturnHandler(this.method().getReturnType());
                if (returnHandler != null) {
                    returnHandler.returnHandle(c, this, c.result);
                } else {
                    this.renderDo(c.result, c);
                }
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            throw e;
        }
    }

    private void bindPathVarDo(Context c) throws Throwable {
        Matcher pm;
        if (this.pathKeysAnalyzer != null && (pm = this.pathKeysAnalyzer.matcher(c.pathNew())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                c.paramMap().add(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
    }

    protected Object executeDo(Context c, Object target) throws Throwable {
        ActionExecuteHandler executeHandler = Solon.app().chainManager().getExecuteHandler(c, this.mWrap.getParamWraps().length);
        Object[] args = executeHandler.resolveArguments(c, target, this.mWrap);
        Solon.app().chainManager().postArguments(c, this.mWrap.getParamWraps(), args);
        return this.mWrap.invokeByAspect(target, args);
    }

    @Override
    public void render(Object obj, Context c, boolean allowMultiple) throws Throwable {
        this.renderDo(obj, c, allowMultiple);
    }

    protected void renderDo(Object obj, Context c) throws Throwable {
        this.renderDo(obj, c, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void renderDo(Object obj, Context c, boolean allowMultiple) throws Throwable {
        obj = Solon.app().chainManager().postResult(c, obj);
        if (allowMultiple || !c.getRendered()) {
            c.result = obj;
        }
        if (this.bRender != null) {
            this.bRender.render(obj, c);
            return;
        }
        if (obj instanceof DataThrowable) {
            return;
        }
        if (obj instanceof Throwable) {
            if (!c.remoting()) {
                c.setHandled(false);
                throw (Throwable)obj;
            }
            Throwable objE = (Throwable)obj;
            LogUtil.global().warn("Action remoting handle failed: " + c.pathNew(), objE);
            if (!allowMultiple) {
                if (c.getRendered()) return;
            }
            c.render(obj);
            return;
        }
        if (!allowMultiple) {
            if (c.getRendered()) return;
        }
        c.render(obj);
    }
}

