/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.IgnoreCaseMap;

public class NvMap
extends IgnoreCaseMap<String> {
    public NvMap() {
    }

    @Deprecated
    public NvMap(Map map) {
        if (map != null) {
            map.forEach((k, v) -> {
                if (k != null && v != null) {
                    this.put(k.toString(), v.toString());
                }
            });
        }
    }

    public static NvMap from(Map map) {
        NvMap d = new NvMap();
        if (map != null) {
            map.forEach((k, v) -> {
                if (k != null && v != null) {
                    d.put(k.toString(), v.toString());
                }
            });
        }
        return d;
    }

    public static NvMap from(String[] args) {
        return NvMap.from(Arrays.asList(args));
    }

    public static NvMap from(List<String> args) {
        NvMap d = new NvMap();
        if (args != null) {
            for (String arg : args) {
                int index = arg.indexOf(61);
                if (index > 0) {
                    String name = arg.substring(0, index);
                    String value = arg.substring(index + 1);
                    d.put(name.replaceAll("^-*", ""), value);
                    continue;
                }
                d.put(arg.replaceAll("^-*", ""), "");
            }
        }
        return d;
    }

    public NvMap set(String key, String val) {
        this.put(key, val);
        return this;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int def) {
        String temp = (String)this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return Integer.parseInt(temp);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long def) {
        String temp = (String)this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return Long.parseLong(temp);
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double def) {
        String temp = (String)this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return Double.parseDouble(temp);
    }

    public boolean getBool(String key, boolean def) {
        if (this.containsKey(key)) {
            return Boolean.parseBoolean((String)this.get(key));
        }
        return def;
    }

    @Deprecated
    public <T> T getBean(Class<T> clz) {
        return this.toBean(clz);
    }

    public <T> T toBean(Class<T> clz) {
        return PropsConverter.global().convert(new Props(this), clz);
    }
}

