/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.exception.InjectionException;
import org.noear.solon.core.runtime.AotCollector;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.ResourceUtil;

public abstract class BeanContainer {
    private final Props props;
    private final ClassLoader classLoader;
    private Map<Class<?>, Object> attachments = new HashMap();
    private final AotCollector aot = new AotCollector();
    protected final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private final Map<Class<?>, BeanWrap> beanWrapsOfType = new HashMap();
    private final Map<String, BeanWrap> beanWrapsOfName = new HashMap<String, BeanWrap>();
    private final Set<BeanWrap> beanWrapSet = new HashSet<BeanWrap>();
    protected final Map<Class<?>, BeanBuilder<?>> beanBuilders = new HashMap();
    protected final Map<Class<?>, BeanInjector<?>> beanInjectors = new HashMap();
    protected final Map<Class<?>, BeanExtractor<?>> beanExtractors = new HashMap();
    protected final Map<Class<?>, InterceptorEntity> beanInterceptors = new HashMap();
    private final Map<Object, Set<Consumer<BeanWrap>>> beanSubscribersOfName = new HashMap<Object, Set<Consumer<BeanWrap>>>();
    private final Map<Object, Set<Consumer<BeanWrap>>> beanSubscribersOfType = new HashMap<Object, Set<Consumer<BeanWrap>>>();
    private final Set<Consumer<BeanWrap>> wrapExternalConsumers = new LinkedHashSet<Consumer<BeanWrap>>();

    public BeanContainer(ClassLoader classLoader, Props props) {
        this.classLoader = classLoader;
        this.props = props;
    }

    public Props cfg() {
        if (this.props == null) {
            return Solon.cfg();
        }
        return this.props;
    }

    public AotCollector aot() {
        return this.aot;
    }

    @Deprecated
    public Map<Class<?>, Object> getAttrs() {
        return this.attachments;
    }

    public <T> T attachmentGet(Class<T> clz) {
        return (T)this.attachments.get(clz);
    }

    public <T> void attachmentSet(Class<T> clz, T val) {
        this.attachments.put(clz, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T attachmentOf(Class<T> clz, Supplier<T> supplier) {
        Object tmp = this.attachments.get(clz);
        if (tmp == null) {
            this.SYNC_LOCK.lock();
            try {
                tmp = this.attachments.get(clz);
                if (tmp == null) {
                    tmp = supplier.get();
                    this.attachments.put(clz, tmp);
                    this.wrapAndPut(clz, tmp);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return (T)tmp;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return AppClassLoader.global();
        }
        return this.classLoader;
    }

    public void clear() {
        this.beanWrapsOfType.clear();
        this.beanWrapsOfName.clear();
        this.beanWrapSet.clear();
        this.attachments.clear();
        this.aot.clear();
        this.wrapExternalConsumers.clear();
    }

    public void copyTo(BeanContainer container) {
        this.beanBuilders.forEach((k, v) -> container.beanBuilders.putIfAbsent((Class<?>)k, (BeanBuilder<?>)v));
        this.beanInjectors.forEach((k, v) -> container.beanInjectors.putIfAbsent((Class<?>)k, (BeanInjector<?>)v));
        this.beanInterceptors.forEach((k, v) -> container.beanInterceptors.putIfAbsent((Class<?>)k, (InterceptorEntity)v));
        this.beanExtractors.forEach((k, v) -> container.beanExtractors.putIfAbsent((Class<?>)k, (BeanExtractor<?>)v));
    }

    public <T extends Annotation> void beanBuilderAdd(Class<T> annoClz, BeanBuilder<T> builder) {
        this.beanBuilders.put(annoClz, builder);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> annoClz, BeanInjector<T> injector) {
        this.beanInjectors.put(annoClz, injector);
    }

    public <T extends Annotation> void beanExtractorAdd(Class<T> annoClz, BeanExtractor<T> extractor) {
        this.beanExtractors.put(annoClz, extractor);
    }

    public boolean beanExtractorHas(Class<? extends Annotation> annoClz) {
        return this.beanExtractors.containsKey(annoClz);
    }

    public <T extends Annotation> void beanInterceptorAdd(Class<T> annoClz, Interceptor interceptor, int index) {
        this.beanInterceptors.put(annoClz, new InterceptorEntity(index, interceptor));
    }

    public <T extends Annotation> void beanInterceptorAdd(Class<T> annoClz, Interceptor interceptor) {
        this.beanInterceptorAdd(annoClz, interceptor, 0);
    }

    public <T extends Annotation> InterceptorEntity beanInterceptorGet(Class<T> annoClz) {
        return this.beanInterceptors.get(annoClz);
    }

    @Deprecated
    public <T extends Annotation> void beanAroundAdd(Class<T> annoClz, Interceptor interceptor, int index) {
        this.beanInterceptorAdd(annoClz, interceptor, index);
    }

    @Deprecated
    public <T extends Annotation> void beanAroundAdd(Class<T> annoClz, Interceptor interceptor) {
        this.beanInterceptorAdd(annoClz, interceptor);
    }

    @Deprecated
    public <T extends Annotation> InterceptorEntity beanAroundGet(Class<T> annoClz) {
        return this.beanInterceptorGet(annoClz);
    }

    private Map<Object, Set<Consumer<BeanWrap>>> getBeanSubscribers(Object nameOrType) {
        if (nameOrType instanceof String) {
            return this.beanSubscribersOfName;
        }
        return this.beanSubscribersOfType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beanSubscribe(Object nameOrType, Consumer<BeanWrap> callback) {
        if (nameOrType != null) {
            this.SYNC_LOCK.lock();
            try {
                Set tmp = this.getBeanSubscribers(nameOrType).computeIfAbsent(nameOrType, k -> new LinkedHashSet());
                tmp.add(callback);
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    protected void wrapExternalSubscribe(Consumer<BeanWrap> callback) {
        this.SYNC_LOCK.lock();
        try {
            this.wrapExternalConsumers.add(callback);
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beanNotice(Object nameOrType, BeanWrap wrap) {
        if (wrap.raw() == null) {
            return;
        }
        this.SYNC_LOCK.lock();
        try {
            Set<Consumer<BeanWrap>> tmp = this.getBeanSubscribers(nameOrType).get(nameOrType);
            if (tmp != null) {
                for (Consumer<BeanWrap> s1 : tmp) {
                    s1.accept(wrap);
                }
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapPublish(BeanWrap wrap) {
        this.SYNC_LOCK.lock();
        try {
            for (Consumer<BeanWrap> s1 : this.wrapExternalConsumers) {
                s1.accept(wrap);
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void removeWrap(String name) {
        if (Utils.isNotEmpty(name)) {
            this.SYNC_LOCK.lock();
            try {
                BeanWrap bw = this.beanWrapsOfName.remove(name);
                if (bw != null) {
                    this.beanWrapSet.remove(bw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void removeWrap(Class<?> type) {
        if (type != null) {
            this.SYNC_LOCK.lock();
            try {
                BeanWrap bw = this.beanWrapsOfType.remove(type);
                if (bw != null) {
                    this.beanWrapSet.remove(bw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void putWrap(String name, BeanWrap wrap) {
        if (Utils.isNotEmpty(name) && wrap.raw() != null) {
            this.SYNC_LOCK.lock();
            try {
                if (!this.beanWrapsOfName.containsKey(name)) {
                    this.beanWrapsOfName.put(name, wrap);
                    this.beanWrapSet.add(wrap);
                    this.beanNotice(name, wrap);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void putWrap(Class<?> type, BeanWrap wrap) {
        if (type != null && wrap.raw() != null) {
            this.SYNC_LOCK.lock();
            try {
                if (!this.beanWrapsOfType.containsKey(type)) {
                    this.beanWrapsOfType.put(type, wrap);
                    this.beanWrapSet.add(wrap);
                    this.beanNotice(type, wrap);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public boolean hasWrap(Object nameOrType) {
        return this.getWrap(nameOrType) != null;
    }

    public BeanWrap getWrap(Object nameOrType) {
        if (nameOrType instanceof String) {
            return this.beanWrapsOfName.get(nameOrType);
        }
        return this.beanWrapsOfType.get(nameOrType);
    }

    public List<BeanWrap> getWrapsOfType(Class<?> baseType) {
        return this.beanFind((BeanWrap bw) -> baseType.isAssignableFrom(bw.rawClz()));
    }

    public void getWrapAsync(Object nameOrType, Consumer<BeanWrap> callback) {
        BeanWrap bw = this.getWrap(nameOrType);
        if (bw == null || bw.raw() == null) {
            this.beanSubscribe(nameOrType, callback);
        } else {
            callback.accept(bw);
        }
    }

    public void subWrapsOfType(Class<?> baseType, Consumer<BeanWrap> callback) {
        this.beanForeach((BeanWrap bw) -> {
            if (baseType.isAssignableFrom(bw.rawClz())) {
                callback.accept((BeanWrap)bw);
            }
        });
        this.wrapExternalSubscribe(bw -> {
            if (baseType.isAssignableFrom(bw.rawClz())) {
                callback.accept((BeanWrap)bw);
            }
        });
    }

    public <T> T getBean(String name) {
        BeanWrap bw = this.getWrap(name);
        return bw == null ? null : (T)bw.get();
    }

    public <T> T getBean(Class<T> type) {
        BeanWrap bw = this.getWrap(type);
        return bw == null ? null : (T)bw.get();
    }

    public <T> List<T> getBeansOfType(Class<T> baseType) {
        List<BeanWrap> beanWraps = this.beanFind((BeanWrap bw) -> baseType.isAssignableFrom(bw.rawClz()));
        ArrayList beans = new ArrayList();
        for (BeanWrap bw2 : beanWraps) {
            beans.add(bw2.raw());
        }
        return beans;
    }

    public <T> Map<String, T> getBeansMapOfType(Class<T> baseType) {
        HashMap beanMap = new HashMap();
        this.beanForeach((BeanWrap bw) -> {
            if (baseType.isAssignableFrom(bw.rawClz())) {
                beanMap.put(bw.name(), bw.raw());
            }
        });
        return beanMap;
    }

    public <T> T getBeanOrNew(Class<T> type) {
        return this.wrapAndPut(type).get();
    }

    public <T> void getBeanAsync(String name, Consumer<T> callback) {
        this.getWrapAsync(name, bw -> callback.accept(bw.get()));
    }

    public <T> void getBeanAsync(Class<T> type, Consumer<T> callback) {
        this.getWrapAsync(type, bw -> callback.accept(bw.get()));
    }

    public <T> void subBeansOfType(Class<T> baseType, Consumer<T> callback) {
        this.subWrapsOfType(baseType, bw -> callback.accept(bw.get()));
    }

    public BeanWrap wrap(Class<?> type) {
        return this.wrap(type, null);
    }

    public BeanWrap wrap(Class<?> type, Object bean) {
        return this.wrap(type, bean, false);
    }

    public BeanWrap wrap(Class<?> type, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(type);
        if (wrap == null) {
            wrap = this.wrapCreate(type, bean, null, typed);
        }
        return wrap;
    }

    public BeanWrap wrap(String name, Object bean) {
        return this.wrap(name, bean, false);
    }

    public BeanWrap wrap(String name, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(name);
        if (wrap == null) {
            wrap = this.wrapCreate(bean.getClass(), bean, name, typed);
        }
        return wrap;
    }

    public BeanWrap wrapAndPut(Class<?> type) {
        return this.wrapAndPut(type, null);
    }

    public BeanWrap wrapAndPut(Class<?> type, Object bean) {
        return this.wrapAndPut(type, bean, false);
    }

    public BeanWrap wrapAndPut(Class<?> type, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(type);
        if (wrap == null) {
            wrap = this.wrapCreate(type, bean, null, typed);
            this.putWrap(type, wrap);
        }
        return wrap;
    }

    protected abstract BeanWrap wrapCreate(Class<?> var1, Object var2, String var3, boolean var4);

    public void beanRegister(BeanWrap bw, String name, boolean typed) {
        if (Utils.isNotEmpty(name)) {
            this.putWrap(name, bw);
            if (!typed) {
                return;
            }
        }
        this.putWrap(bw.rawClz(), bw);
        this.putWrap(bw.rawClz().getName(), bw);
        if (!bw.rawClz().equals(bw.clz())) {
            this.putWrap(bw.clz(), bw);
            this.putWrap(bw.clz().getName(), bw);
        }
        this.beanRegisterSup0(bw);
        if (bw.remoting()) {
            Solon.app().router().add(bw);
        }
    }

    protected void beanRegisterSup0(BeanWrap bw) {
        Type[] list2;
        Class<?>[] list;
        for (Class<?> c : list = bw.rawClz().getInterfaces()) {
            if (c.getName().startsWith("java.")) continue;
            this.putWrap(c, bw);
        }
        for (Type t : list2 = bw.rawClz().getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            this.putWrap(t.getTypeName(), bw);
        }
    }

    public void beanInject(VarHolder varH, String name) {
        this.beanInject(varH, name, false, false);
    }

    protected void beanInject(VarHolder varH, String name, boolean required, boolean autoRefreshed) {
        try {
            varH.required(required);
            this.beanInjectDo(varH, name, required, autoRefreshed);
        }
        catch (InjectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InjectionException("Injection failed: " + varH.getFullName(), e);
        }
    }

    private void beanInjectDo(VarHolder varH, String name, boolean required, boolean autoRefreshed) {
        if (Utils.isEmpty(name)) {
            if (varH.getType() == null) {
                if (required) {
                    throw new InjectionException("Unrecognized type\uff0cinjection failed: " + varH.getFullName());
                }
                return;
            }
            if (AppContext.class.isAssignableFrom(varH.getType())) {
                varH.setValue(this);
                return;
            }
            if (SolonApp.class.isAssignableFrom(varH.getType())) {
                varH.setValue(Solon.app());
                return;
            }
            if (varH.getGenericType() != null) {
                this.getWrapAsync(varH.getGenericType().getTypeName(), bw -> varH.setValue(bw.get()));
                if (!Iterable.class.isAssignableFrom(varH.getType()) && !Map.class.isAssignableFrom(varH.getType())) {
                    this.lifecycle(() -> {
                        BeanWrap bw;
                        if (!varH.isDone() && (bw = this.getWrap(varH.getType())) != null) {
                            varH.setValue(bw.get());
                        }
                    });
                }
            } else {
                this.getWrapAsync(varH.getType(), bw -> varH.setValue(bw.get()));
            }
        } else if (name.startsWith("${classpath:")) {
            String url = name.substring(12, name.length() - 1);
            Properties val2 = Utils.loadProperties(ResourceUtil.getResource(this.getClassLoader(), url));
            if (val2 == null) {
                if (required) {
                    throw new IllegalStateException(name + "  failed to load!");
                }
            } else if (Properties.class == varH.getType()) {
                varH.setValue(val2);
            } else if (Map.class == varH.getType()) {
                HashMap val22 = new HashMap();
                val2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        val22.put((String)k, (String)v);
                    }
                }));
                varH.setValue(val22);
            } else {
                Object val23 = PropsConverter.global().convert(val2, null, varH.getType(), varH.getGenericType());
                varH.setValue(val23);
                this.aot().registerEntityType(varH.getType(), varH.getGenericType());
            }
        } else if (name.startsWith("${")) {
            String name2 = this.findConfigKey(name);
            this.beanInjectConfig(varH, name2, required);
            if (autoRefreshed && varH.isField()) {
                int defIdx = name2.indexOf(":");
                if (defIdx > 0) {
                    name2 = name2.substring(0, defIdx).trim();
                }
                String name3 = name2;
                this.cfg().onChange((key, val) -> {
                    if (key.startsWith(name3)) {
                        this.beanInjectConfig(varH, name3, required);
                    }
                });
            }
        } else {
            this.getWrapAsync(name, bw -> {
                if (BeanWrap.class.isAssignableFrom(varH.getType())) {
                    varH.setValue(bw);
                } else {
                    varH.setValue(bw.get());
                }
            });
        }
    }

    protected void beanInjectProperties(Class<?> clz, Object obj) {
        Inject typeInj = clz.getAnnotation(Inject.class);
        if (typeInj != null && Utils.isNotEmpty(typeInj.value())) {
            String name = typeInj.value();
            if (name.startsWith("${classpath:")) {
                String url = name.substring(12, name.length() - 1);
                Properties val2 = Utils.loadProperties(ResourceUtil.getResource(this.getClassLoader(), url));
                if (val2 == null) {
                    if (typeInj.required()) {
                        throw new IllegalStateException(name + "  failed to load!");
                    }
                } else {
                    Utils.injectProperties(obj, val2);
                }
            } else if (typeInj.value().startsWith("${")) {
                String name2 = this.findConfigKey(name);
                this.beanInjectPropertiesDo(name, obj, this.cfg().getProp(name2), typeInj.required());
                if (typeInj.autoRefreshed()) {
                    this.cfg().onChange((key, val) -> {
                        if (key.startsWith(name2)) {
                            this.beanInjectPropertiesDo(name, obj, this.cfg().getProp(name2), typeInj.required());
                        }
                    });
                }
            }
        }
    }

    protected String findConfigKey(String name) {
        String name2 = name.substring(2, name.length() - 1).trim();
        int index = name2.indexOf(58);
        if (index > 0) {
            String rawName = name2.substring(0, index);
            String nextName = name2.substring(index + 1);
            if (nextName.startsWith("${") && !this.cfg().containsKey(rawName)) {
                return this.findConfigKey(nextName);
            }
        }
        return name2;
    }

    private void beanInjectPropertiesDo(String name, Object obj, Properties val, boolean required) {
        if (required && val.size() == 0) {
            throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + obj.getClass().getName());
        }
        Utils.injectProperties(obj, val);
    }

    private void beanInjectConfig(VarHolder varH, String name, boolean required) {
        if (Properties.class == varH.getType() || Props.class == varH.getType()) {
            Props val = this.cfg().getProp(name);
            if (required && val.size() == 0) {
                throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + varH.getFullName());
            }
            varH.setValue(val);
        } else {
            String val = this.cfg().getByExpr(name);
            if (val == null && (Character.isUpperCase(name.charAt(0)) || name.charAt(0) == '_')) {
                val = System.getenv(name);
            }
            if (val == null) {
                Class<?> pt = varH.getType();
                if (pt.getName().startsWith("java.lang.") || pt.isPrimitive()) {
                    if (required) {
                        throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + varH.getFullName());
                    }
                    varH.setValue(null);
                } else {
                    Props val0 = this.cfg().getProp(name);
                    if (((Properties)val0).size() > 0) {
                        Object val2 = PropsConverter.global().convert(val0, null, pt, varH.getGenericType());
                        varH.setValue(val2);
                        this.aot().registerEntityType(varH.getType(), varH.getGenericType());
                    } else {
                        if (required) {
                            throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + varH.getFullName());
                        }
                        varH.setValue(null);
                    }
                }
            } else {
                Object val2 = ConvertUtil.to(varH.getType(), varH.getGenericType(), val);
                varH.setValue(val2);
                this.aot().registerEntityType(varH.getType(), varH.getGenericType());
            }
        }
    }

    public abstract void lifecycle(Lifecycle var1);

    public abstract void lifecycle(int var1, Lifecycle var2);

    public void beanForeach(BiConsumer<String, BeanWrap> action) {
        this.beanWrapsOfName.forEach(action);
    }

    public void beanForeach(Consumer<BeanWrap> action) {
        Object[] array;
        for (Object bw : array = this.beanWrapSet.toArray()) {
            action.accept((BeanWrap)bw);
        }
    }

    public List<BeanWrap> beanFind(BiPredicate<String, BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((String k, BeanWrap v) -> {
            if (condition.test((String)k, (BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        if (list.size() > 0) {
            list.sort(Comparator.comparingInt(bw -> bw.index()));
        }
        return list;
    }

    public List<BeanWrap> beanFind(Predicate<BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((BeanWrap v) -> {
            if (condition.test((BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        if (list.size() > 0) {
            list.sort(Comparator.comparingInt(bw -> bw.index()));
        }
        return list;
    }

    protected void beanStop0() {
        for (BeanWrap bw : this.beanWrapSet) {
            if (!(bw.raw() instanceof Closeable)) continue;
            try {
                ((Closeable)bw.raw()).close();
            }
            catch (Throwable throwable) {}
        }
    }
}

