/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.PropUtil;
import org.noear.solon.core.util.ResourceUtil;

public class Props
extends Properties {
    private ClassLoader classLoader;
    private Map<String, String> tempPropMap = new TreeMap<String, String>();
    private ReentrantLock SYNC_LOCK = new ReentrantLock();
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public Props() {
    }

    public Props(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Props(Properties defaults) {
        super(defaults);
    }

    public Props(Map<String, String> data) {
        super.putAll(data);
    }

    @Override
    public int size() {
        this.SYNC_LOCK.lock();
        try {
            if (this.defaults == null) {
                int n = super.size();
                return n;
            }
            int n = super.size() + this.defaults.size();
            return n;
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String getByKeys(String ... keys) {
        for (String key : keys) {
            String tmp = this.get(key);
            if (!Utils.isNotEmpty(tmp)) continue;
            return tmp;
        }
        return null;
    }

    public String getByExpr(String expr) {
        return this.getByExpr(expr, null);
    }

    protected String getByExpr(String expr, Properties props) {
        return PropUtil.getByExp(this, props, expr);
    }

    @Deprecated
    public String getByParse(String tml) {
        return this.getByTmpl(tml);
    }

    public String getByTmpl(String tmpl) {
        return this.getByTmpl(tmpl, null);
    }

    protected String getByTmpl(String tmpl, Properties props) {
        return PropUtil.getByTml(this, props, tmpl);
    }

    protected String getByTmpl(String tml, Properties props, boolean useDef) {
        return PropUtil.getByTml(this, props, tml, useDef);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDefault(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDefault(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDefault(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDefault(key, def, Double::parseDouble);
    }

    public <T> T getOrDefault(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public <T> T getBean(String keyStarts, Class<T> clz) {
        Props props = this.getProp(keyStarts);
        return PropsConverter.global().convert(props, clz);
    }

    public <T> T getBean(Class<T> clz) {
        return PropsConverter.global().convert(this, clz);
    }

    public <T> T bindTo(T obj) {
        PropsConverter.global().convert(this, obj, null, null);
        return obj;
    }

    public Props getProp(String keyStarts) {
        if (Utils.isEmpty(keyStarts)) {
            return this;
        }
        Props prop = new Props();
        this.doFind(keyStarts, (key, val) -> {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            prop.put(key, val);
        });
        return prop;
    }

    public Map<String, Props> getGroupedProp(String keyStarts) {
        Props rootProps = this.getProp(keyStarts);
        HashSet<String> groups = new HashSet<String>();
        for (Object key : rootProps.keySet()) {
            if (!(key instanceof String)) continue;
            groups.add(((String)key).split("\\.")[0]);
        }
        LinkedHashMap<String, Props> groupProps = new LinkedHashMap<String, Props>();
        for (String group : groups) {
            Props tmp = rootProps.getProp(group);
            groupProps.put(group, tmp);
        }
        return groupProps;
    }

    public Props getPropByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.getProp(name);
    }

    @Deprecated
    public NvMap getXmap(String keyStarts) {
        NvMap map = new NvMap();
        this.doFind(keyStarts + ".", map::put);
        return map;
    }

    public Map<String, String> getMap(String keyStarts) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.doFind(keyStarts, (key, val) -> {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            map.put((String)key, (String)val);
        });
        return map;
    }

    public List<String> getList(String keyStarts) {
        TreeMap sortMap = new TreeMap();
        this.doFind(keyStarts + "[", (k, v) -> sortMap.put(k, v));
        return new ArrayList<String>(sortMap.values());
    }

    protected void doFind(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts;
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                String key = keyStr.substring(idx2);
                setFun.accept(key, (String)v);
                if (key.indexOf(45) >= 0) {
                    String camelKey = Utils.snakeToCamel(key);
                    setFun.accept(camelKey, (String)v);
                }
            }
        }));
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.SYNC_LOCK.lock();
        try {
            super.forEach(action);
            if (this.defaults != null) {
                this.defaults.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (!super.containsKey(k)) {
                        action.accept(k, v);
                    }
                }));
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        this.SYNC_LOCK.lock();
        try {
            Object obj = super.put(key, value);
            if (key instanceof String && value instanceof String) {
                this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
            }
            Object object = obj;
            return object;
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void putIfNotNull(Object key, Object value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
    }

    public void loadAdd(String name) {
        this.loadAdd(ResourceUtil.getResource(this.classLoader, name));
    }

    public void loadAdd(Import anno) {
        if (anno == null) {
            return;
        }
        for (String uri : anno.profiles()) {
            uri = this.getByTmpl(uri);
            this.loadAdd(ResourceUtil.findResource(this.classLoader, uri));
        }
        for (String uri : anno.profilesIfAbsent()) {
            uri = this.getByTmpl(uri);
            this.loadAddIfAbsent(ResourceUtil.findResource(this.classLoader, uri));
        }
    }

    @Deprecated
    public void loadAdd(PropertySource anno) {
        if (anno == null) {
            return;
        }
        for (String uri : anno.value()) {
            uri = this.getByTmpl(uri);
            this.loadAdd(ResourceUtil.findResource(this.classLoader, uri));
        }
    }

    public void loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
    }

    public void loadAdd(Properties props) {
        this.loadAddDo(props, false, false);
    }

    public void loadAddIfAbsent(String name) {
        this.loadAddIfAbsent(ResourceUtil.getResource(this.classLoader, name));
    }

    public void loadAddIfAbsent(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAddIfAbsent(props);
        }
    }

    public void loadAddIfAbsent(Properties props) {
        this.loadAddDo(props, false, true);
    }

    protected void loadAddDo(Properties props, boolean toSystem, boolean addIfAbsent) {
        this.loadAddDo(props, toSystem, addIfAbsent, false);
        this.reviseDo(false);
    }

    protected void loadAddDo(Properties props, boolean toSystem, boolean addIfAbsent, boolean isEnd) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String key;
                Object k1 = kv.getKey();
                Object v1 = kv.getValue();
                if (addIfAbsent && this.containsKey(k1)) {
                    this.tempPropMap.remove(k1);
                    continue;
                }
                if (!(k1 instanceof String) || Utils.isEmpty(key = (String)k1)) continue;
                if (v1 instanceof String) {
                    String valExp = (String)v1;
                    if ((v1 = this.getByTmpl(valExp, props, isEnd)) == null) {
                        if (!isEnd) {
                            this.tempPropMap.put(key, valExp);
                        }
                    } else {
                        this.tempPropMap.remove(key);
                    }
                }
                if (v1 == null) continue;
                this.put(k1, v1);
                if (key.indexOf(45) < 0) {
                    if (!toSystem) continue;
                    System.getProperties().put(k1, v1);
                    continue;
                }
                String camelKey = Utils.snakeToCamel(key);
                if (addIfAbsent) {
                    this.putIfAbsent(camelKey, v1);
                    continue;
                }
                this.put(camelKey, v1);
            }
        }
    }

    public void complete() {
        this.reviseDo(true);
    }

    protected void reviseDo(boolean isEnd) {
        if (this.tempPropMap.size() == 0) {
            return;
        }
        Properties tempProps = new Properties();
        tempProps.putAll(this.tempPropMap);
        this.loadAddDo(tempProps, false, isEnd, isEnd);
        if (isEnd && this.tempPropMap.size() > 0) {
            throw new IllegalStateException("Config verification failed: " + this.tempPropMap);
        }
    }
}

