/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Method;
import org.noear.solon.lang.Nullable;

public class MethodKey
implements Comparable<MethodKey> {
    private final Method method;
    @Nullable
    private final Class<?> targetClass;

    public MethodKey(Method method, @Nullable Class<?> targetClass) {
        this.method = method;
        this.targetClass = targetClass;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)o;
        if (this.method.equals(other.method)) {
            if (this.targetClass == other.targetClass) {
                return true;
            }
            if (this.targetClass != null && other.targetClass != null) {
                return this.targetClass.equals(other.targetClass);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.targetClass == null) {
            return this.method.hashCode();
        }
        return this.method.hashCode() * 31 + this.targetClass.hashCode();
    }

    public String toString() {
        if (this.targetClass == null) {
            return this.method.toString();
        }
        return this.method.toString() + " on " + this.targetClass.getName();
    }

    @Override
    public int compareTo(MethodKey o) {
        int result = this.method.getName().compareTo(o.method.getName());
        if (result == 0 && (result = this.method.toString().compareTo(o.method.toString())) == 0 && this.targetClass != null && o.targetClass != null) {
            result = this.targetClass.getName().compareTo(o.targetClass.getName());
        }
        return result;
    }
}

