/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Signal;
import org.noear.solon.core.convert.ConverterManager;
import org.noear.solon.core.event.AppBeanLoadEndEvent;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.AppPluginInitEndEvent;
import org.noear.solon.core.event.AppPluginLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextPathFilter;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.route.RouterWrapper;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;

public class SolonApp
extends RouterWrapper {
    private final SolonProps _cfg;
    private final AppContext _context;
    private final ConverterManager _converterManager;
    private final Class<?> _source;
    private final URL _sourceLocation;
    private final long _startupTime;
    protected boolean stopped = false;
    private final Map<Integer, Signal> signals = new LinkedHashMap<Integer, Signal>();
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private Handler _handler = null;
    private Map<Integer, Handler> _statusHandlers = new HashMap<Integer, Handler>();
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = false;
    private boolean _enableSocketD = false;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;
    private boolean _enableSessionState = true;

    @Override
    public AppContext context() {
        return this._context;
    }

    public ConverterManager converterManager() {
        return this._converterManager;
    }

    public FactoryManager factoryManager() {
        return FactoryManager.getGlobal();
    }

    public SolonProps cfg() {
        return this._cfg;
    }

    protected SolonApp(Class<?> source, NvMap args) throws Exception {
        this._startupTime = System.currentTimeMillis();
        this._source = source;
        this._sourceLocation = source.getProtectionDomain().getCodeSource().getLocation();
        this._converterManager = new ConverterManager();
        if (source == null) {
            throw new IllegalArgumentException("The startup class parameter('source') cannot be null");
        }
        if (source.getPackage() == null || Utils.isEmpty(source.getPackage().getName())) {
            throw new IllegalStateException("The startup class is missing package: " + source.getName());
        }
        this._cfg = new SolonProps(this, args);
        this._context = new AppContext(new AppClassLoader(AppClassLoader.global()), this._cfg);
        this.initRouter(this::doFilter);
        this._handler = this.routerHandler();
    }

    protected void start(ConsumerEx<SolonApp> initialize) throws Throwable {
        if (this._cfg.warns.size() > 0) {
            for (String warn : this._cfg.warns) {
                LogUtil.global().warn(warn);
            }
        }
        this.initAwait();
        this.init(initialize);
        this.run();
    }

    private void initAwait() throws Throwable {
        String addr = this.cfg().get("solon.start.ping");
        if (Utils.isNotEmpty(addr)) {
            try {
                while (true) {
                    if (Utils.ping(addr)) {
                        LogUtil.global().info("App: Start ping succeed: " + addr);
                        Thread.sleep(1000L);
                        break;
                    }
                    LogUtil.global().warn("App: Start ping failure: " + addr);
                    Thread.sleep(2000L);
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void init(ConsumerEx<SolonApp> initialize) throws Throwable {
        List<ClassLoader> loaderList;
        String filterStr = this.cfg().extendFilter();
        if (Utils.isEmpty(filterStr)) {
            loaderList = ExtendLoader.load(this.cfg().extend(), false);
        } else {
            String[] filterS = filterStr.split(",");
            loaderList = ExtendLoader.load(this.cfg().extend(), false, path -> {
                for (String f : filterS) {
                    if (!path.contains(f)) continue;
                    return true;
                }
                return false;
            });
        }
        this.cfg().plugsScan(loaderList);
        if (initialize != null) {
            initialize.accept(this);
        }
    }

    private void run() throws Throwable {
        int i;
        EventBus.publish(new AppInitEndEvent(this));
        List<PluginEntity> plugs = this.cfg().plugs();
        int len = plugs.size();
        for (i = 0; i < len; ++i) {
            if (Solon.cfg().isDebugMode()) {
                LogUtil.global().info("App: plugin init: " + plugs.get(i).getClassName());
            }
            plugs.get(i).init(this.context());
        }
        EventBus.publish(new AppPluginInitEndEvent(this));
        LogUtil.global().info("App: Plugin starting");
        len = plugs.size();
        for (i = 0; i < len; ++i) {
            plugs.get(i).start(this.context());
        }
        this.cfg().complete();
        EventBus.publish(new AppPluginLoadEndEvent(this));
        LogUtil.global().info("App: Bean scanning");
        this.beanImportTry();
        if (this.source() != null) {
            this.context().beanScan(this.source());
        }
        EventBus.publish(new AppBeanLoadEndEvent(this));
        Map<String, String> map = this.cfg().getMap("solon.view.mapping.");
        map.forEach((k, v) -> RenderManager.mapping("." + k, v));
        if (Utils.isNotEmpty(Solon.cfg().serverContextPath())) {
            Solon.app().filterIfAbsent(-99, new ContextPathFilter());
        }
        this.context().start();
        EventBus.publish(new AppLoadEndEvent(this));
    }

    protected void beanImportTry() {
        if (this._source == null) {
            return;
        }
        for (Annotation a1 : this._source.getAnnotations()) {
            if (a1 instanceof Import) {
                this.context().beanImport((Import)a1);
                continue;
            }
            this.context().beanImport(a1.annotationType().getAnnotation(Import.class));
        }
    }

    public void signalAdd(Signal instance) {
        this.signals.putIfAbsent(instance.port(), instance);
    }

    public Signal signalGet(int port) {
        return this.signals.get(port);
    }

    public Collection<Signal> signals() {
        return Collections.unmodifiableCollection(this.signals.values());
    }

    public ClassLoader classLoader() {
        return this.context().getClassLoader();
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    protected long elapsedTimes() {
        return System.currentTimeMillis() - this._startupTime;
    }

    public Class<?> source() {
        return this._source;
    }

    public URL sourceLocation() {
        return this._sourceLocation;
    }

    @Deprecated
    public void plug(Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin);
        p.init(this.context());
        p.start(this.context());
        this.cfg().plugs().add(p);
    }

    @Deprecated
    public void pluginAdd(int priority, Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin, priority);
        this.cfg().plugs().add(p);
        this.cfg().plugsSort();
    }

    public Handler handlerGet() {
        return this._handler;
    }

    public void handlerSet(Handler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryHandle(Context x) {
        block14: {
            try {
                ContextUtil.currentSet(x);
                if (this.stopped) {
                    x.status(503);
                } else {
                    this.chainManager().doFilter(x);
                }
                this.doStatus(x);
            }
            catch (Throwable ex) {
                ex = Utils.throwableUnwrap(ex);
                LogUtil.global().warn("SolonApp tryHandle failed!", ex);
                if (ex instanceof StatusException) {
                    x.status(((StatusException)ex).getCode());
                } else if (!x.getHandled() && x.status() < 400) {
                    x.status(500);
                }
                if (x.getRendered()) break block14;
                try {
                    if (!this.doStatus(x) && Solon.cfg().isDebugMode()) {
                        x.output(ex);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                ContextUtil.currentRemove();
            }
        }
    }

    protected void doFilter(Context x, FilterChain chain) throws Throwable {
        this._handler.handle(x);
    }

    protected boolean doStatus(Context x) throws Throwable {
        Handler h;
        if (x.status() >= 400 && this._statusHandlers.size() > 0 && (h = this._statusHandlers.get(x.status())) != null) {
            x.status(200);
            x.setHandled(true);
            h.handle(x);
            return true;
        }
        return false;
    }

    public <T> SolonApp onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public <T> SolonApp onEvent(Class<T> type, int index, EventListener<T> handler) {
        EventBus.subscribe(type, index, handler);
        return this;
    }

    public SolonApp onStatus(Integer code, Handler handler) {
        this._statusHandlers.put(code, handler);
        return this;
    }

    public void block() throws InterruptedException {
        Thread.currentThread().join();
    }

    public boolean enableHttp() {
        return this._enableHttp && NativeDetector.isNotAotRuntime();
    }

    public SolonApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket && NativeDetector.isNotAotRuntime();
    }

    public SolonApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableSocketD() {
        return this._enableSocketD && NativeDetector.isNotAotRuntime();
    }

    public SolonApp enableSocketD(boolean enable) {
        this._enableSocketD = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public SolonApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public SolonApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public SolonApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }

    public boolean enableSessionState() {
        return this._enableSessionState;
    }

    public SolonApp enableSessionState(boolean enable) {
        this._enableSessionState = enable;
        return this;
    }
}

