/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.FileNameMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.PropsLoader;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.core.wrap.ClassWrap;

public class Utils {
    @Deprecated
    public static final String TAG_classpath = "classpath:";
    private static ReentrantLock comLocker = new ReentrantLock();
    private static final FileNameMap mimeMap = URLConnection.getFileNameMap();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static AtomicReference<String> _appFolder;
    private static String _pid;

    public static ReentrantLock locker() {
        return comLocker;
    }

    public static Future<?> async(Runnable task) {
        return RunUtil.async(task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ping(String address) throws Exception {
        if (!address.contains(":")) return InetAddress.getByName(address).isReachable(3000);
        String host = address.split(":")[0];
        int port = Integer.parseInt(address.split(":")[1]);
        try (Socket socket = new Socket();){
            InetSocketAddress addr = new InetSocketAddress(host, port);
            socket.connect(addr, 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static <T> List<T> asList(T[] ary) {
        if (ary == null) {
            return null;
        }
        ArrayList list = new ArrayList(ary.length);
        Collections.addAll(list, ary);
        return list;
    }

    public static String mime(String fileName) {
        String tmp = mimeMap.getContentTypeFor(fileName);
        if (tmp == null) {
            return "application/octet-stream";
        }
        return tmp;
    }

    public static String annoAlias(String v1, String v2) {
        if (Utils.isEmpty(v1)) {
            return v2;
        }
        return v1;
    }

    public static boolean isProxyClass(Class<?> clz) {
        return clz.getName().contains("$$Solon");
    }

    public static String guid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String md5(String str) {
        try {
            byte[] btInput = str.getBytes("UTF-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] chars = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                chars[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                chars[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(chars);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Deprecated
    public static Collection<String> resolvePaths(String pathExpr) {
        return ResourceUtil.scanResources(pathExpr);
    }

    public static String throwableToString(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Throwable throwableUnwrap(Throwable ex) {
        Throwable th = ex;
        while (true) {
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getClass() != RuntimeException.class || th.getCause() == null) break;
            th = th.getCause();
        }
        return th;
    }

    public static boolean throwableHas(Throwable ex, Class<? extends Throwable> clz) {
        Throwable th = ex;
        while (true) {
            if (clz.isAssignableFrom(th.getClass())) {
                return true;
            }
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
                continue;
            }
            if (th instanceof UndeclaredThrowableException) {
                th = ((UndeclaredThrowableException)th).getUndeclaredThrowable();
                continue;
            }
            if (th.getCause() == null) break;
            th = th.getCause();
        }
        return false;
    }

    public static String trimDuplicates(String str, char c) {
        int start = 0;
        while ((start = str.indexOf(c, start) + 1) > 0) {
            int end;
            for (end = start; end < str.length() && str.charAt(end) == c; ++end) {
            }
            if (end <= start) continue;
            str = str.substring(0, start) + str.substring(end);
        }
        return str;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Collection s) {
        return s == null || s.size() == 0;
    }

    public static boolean isEmpty(Map s) {
        return s == null || s.size() == 0;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !Utils.isEmpty(s);
    }

    public static boolean isNotEmpty(Collection s) {
        return !Utils.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        if (Utils.isEmpty(s)) {
            return true;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (Utils.isWhitespace(s.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String s) {
        return !Utils.isBlank(s);
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13;
    }

    public static <T> T firstOrNull(List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static <T> T[] toArray(List<T> list, T[] a) {
        if (list != null) {
            return list.toArray(a);
        }
        return null;
    }

    public static Locale toLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String[] ss = lang.split("_|-");
        if (ss.length >= 3) {
            if (ss[1].length() > 2) {
                return new Locale(ss[0], ss[2], ss[1]);
            }
            return new Locale(ss[0], ss[1], ss[2]);
        }
        if (ss.length == 2) {
            if (ss[1].length() > 2) {
                return new Locale(ss[0], "", ss[1]);
            }
            return new Locale(ss[0], ss[1]);
        }
        return new Locale(ss[0]);
    }

    @Deprecated
    public static boolean hasClass(SupplierEx<Class<?>> test) {
        return ClassUtil.hasClass(test);
    }

    @Deprecated
    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(className);
    }

    @Deprecated
    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        return ClassUtil.loadClass(classLoader, className);
    }

    @Deprecated
    public static <T> T newInstance(String className) {
        return ClassUtil.tryInstance(className);
    }

    @Deprecated
    public static <T> T newInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(className, prop);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        return ClassUtil.tryInstance(classLoader, className, prop);
    }

    @Deprecated
    public static <T> T newInstance(Class<?> clz) throws Exception {
        return ClassUtil.newInstance(clz);
    }

    @Deprecated
    public static <T> T newInstance(Class<?> clz, Properties prop) throws Exception {
        return ClassUtil.newInstance(clz, prop);
    }

    @Deprecated
    public static Enumeration<URL> getResources(String name) throws IOException {
        return ResourceUtil.getResources(name);
    }

    @Deprecated
    public static Enumeration<URL> getResources(ClassLoader classLoader, String name) throws IOException {
        return ResourceUtil.getResources(classLoader, name);
    }

    @Deprecated
    public static URL getResource(String name) {
        return ResourceUtil.getResource(name);
    }

    @Deprecated
    public static URL getResource(ClassLoader classLoader, String name) {
        return ResourceUtil.getResource(classLoader, name);
    }

    @Deprecated
    public static String getResourceAsString(String name) throws IOException {
        return ResourceUtil.getResourceAsString(name);
    }

    @Deprecated
    public static String getResourceAsString(String name, String charset) throws IOException {
        return ResourceUtil.getResourceAsString(name, charset);
    }

    @Deprecated
    public static String getResourceAsString(ClassLoader classLoader, String name, String charset) throws IOException {
        return ResourceUtil.getResourceAsString(classLoader, name, charset);
    }

    @Deprecated
    public static String transferToString(InputStream ins) throws IOException {
        return IoUtil.transferToString(ins);
    }

    @Deprecated
    public static String transferToString(InputStream ins, String charset) throws IOException {
        return IoUtil.transferToString(ins, charset);
    }

    @Deprecated
    public static byte[] transferToBytes(InputStream ins) throws IOException {
        return IoUtil.transferToBytes(ins);
    }

    @Deprecated
    public static <T extends OutputStream> T transferTo(InputStream ins, T out) throws IOException {
        return IoUtil.transferTo(ins, out);
    }

    public static Properties loadProperties(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return PropsLoader.global().load(url);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(String url) {
        return Utils.loadProperties(Utils.getResource(url));
    }

    public static Properties buildProperties(String txt) {
        try {
            return PropsLoader.global().build(txt);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T injectProperties(T obj, Properties propS) {
        return PropsConverter.global().convert(propS, obj, null, null);
    }

    public static String getFullStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static String appFolder() {
        if (_appFolder == null) {
            _appFolder = new AtomicReference();
            if (NativeDetector.inNativeImage()) {
                String uri = Utils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                int endIdx = uri.lastIndexOf("/") + 1;
                uri = uri.startsWith("file:/") ? uri.substring(5, endIdx) : uri.substring(0, endIdx);
                _appFolder.set(uri);
            } else {
                URL temp = ResourceUtil.getResource("/");
                if (temp == null) {
                    temp = ResourceUtil.getResource("");
                }
                if (temp == null) {
                    _appFolder.set(null);
                } else {
                    int endIdx;
                    String uri = temp.getPath();
                    if (uri.contains("jar!/")) {
                        endIdx = uri.indexOf("jar!/");
                        endIdx = uri.lastIndexOf("/", endIdx) + 1;
                    } else {
                        endIdx = uri.lastIndexOf("/classes/");
                        endIdx = endIdx > 0 ? ++endIdx : uri.lastIndexOf("/") + 1;
                    }
                    uri = uri.startsWith("file:/") ? uri.substring(5, endIdx) : uri.substring(0, endIdx);
                    _appFolder.set(uri);
                }
            }
        }
        return _appFolder.get();
    }

    public static File getFile(String uri) {
        if (uri == null) {
            return null;
        }
        String appDir = Utils.appFolder();
        File file = null;
        if (appDir != null) {
            if (uri.startsWith("./")) {
                file = new File(appDir, uri.substring(2));
            } else if (!uri.contains("/")) {
                file = new File(appDir, uri);
            }
        }
        if (file == null) {
            file = new File(uri);
        }
        return file;
    }

    public static File getFolderAndMake(String uri, boolean autoMake) {
        File extDir = Utils.getFile(uri);
        if (extDir != null && autoMake && !extDir.exists()) {
            extDir.mkdirs();
        }
        return extDir;
    }

    @Deprecated
    public static File buildExt(String extend, boolean autoMake) {
        return Utils.getFolderAndMake(extend, autoMake);
    }

    public static void bindTo(Map<String, String> source, Object target) {
        Utils.bindTo((String k) -> (String)source.get(k), target);
    }

    public static void bindTo(Properties source, Object target) {
        Utils.injectProperties(target, source);
    }

    public static void bindTo(Function<String, String> source, Object target) {
        if (target == null) {
            return;
        }
        ClassWrap.get(target.getClass()).fill(target, source);
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Utils.getContextClassLoader();
        if (classLoader == null && null == (classLoader = Utils.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static String pid() {
        if (_pid == null) {
            RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
            _pid = rb.getName().split("@")[0];
            System.setProperty("PID", _pid);
        }
        return _pid;
    }
}

