/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Around;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.MethodHolder;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.lang.Nullable;

public class MethodWrap
implements Interceptor,
MethodHolder {
    private final AppContext context;
    private final Class<?> declaringClz;
    private final Method method;
    private final ParamWrap[] parameters;
    private ParamWrap bodyParameter;
    private final Annotation[] annotations;
    private final List<InterceptorEntity> interceptors;
    private final Set<Interceptor> interceptorsIdx;
    private boolean isRequiredBody;

    public MethodWrap(AopContext ctx, Method m) {
        InterceptorEntity ie;
        this.context = (AppContext)ctx;
        this.declaringClz = m.getDeclaringClass();
        this.method = m;
        this.parameters = this.buildParamsWrap(m.getParameters());
        this.annotations = m.getAnnotations();
        this.interceptors = new ArrayList<InterceptorEntity>();
        this.interceptorsIdx = new HashSet<Interceptor>();
        for (Annotation anno : this.annotations) {
            if (anno instanceof Around) {
                this.doInterceptorAdd((Around)anno);
                continue;
            }
            ie = this.context.beanInterceptorGet(anno.annotationType());
            if (ie != null) {
                this.doInterceptorAdd(ie);
                continue;
            }
            this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
        }
        for (Annotation anno : this.declaringClz.getAnnotations()) {
            if (anno instanceof Around) {
                this.doInterceptorAdd((Around)anno);
                continue;
            }
            ie = this.context.beanInterceptorGet(anno.annotationType());
            if (ie != null) {
                this.doInterceptorAdd(ie);
                continue;
            }
            this.doInterceptorAdd(anno.annotationType().getAnnotation(Around.class));
        }
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        this.interceptors.add(new InterceptorEntity(0, this));
    }

    private ParamWrap[] buildParamsWrap(Parameter[] pAry) {
        ParamWrap[] tmp = new ParamWrap[pAry.length];
        int len = pAry.length;
        for (int i = 0; i < len; ++i) {
            tmp[i] = new ParamWrap(pAry[i]);
            if (!tmp[i].isRequiredBody()) continue;
            this.isRequiredBody = true;
            this.bodyParameter = tmp[i];
        }
        return tmp;
    }

    private void doInterceptorAdd(Around a) {
        if (a != null) {
            this.doInterceptorAdd(new InterceptorEntity(a.index(), this.context.getBeanOrNew(a.value())));
        }
    }

    private void doInterceptorAdd(InterceptorEntity i) {
        if (i != null) {
            if (this.interceptorsIdx.contains(i.getReal())) {
                return;
            }
            this.interceptorsIdx.add(i.getReal());
            this.interceptors.add(i);
        }
    }

    public boolean isRequiredBody() {
        return this.isRequiredBody;
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?> getDeclaringClz() {
        return this.declaringClz;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    @Override
    public ParamWrap[] getParamWraps() {
        return this.parameters;
    }

    @Nullable
    public ParamWrap getBodyParamWrap() {
        return this.bodyParameter;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.method.getAnnotation(type);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    @Override
    @Deprecated
    public List<InterceptorEntity> getArounds() {
        return this.getInterceptors();
    }

    @Override
    public List<InterceptorEntity> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public Object doIntercept(Invocation inv) throws Throwable {
        return this.invoke(inv.target(), inv.args());
    }

    public Object invoke(Object obj, Object[] args) throws Throwable {
        try {
            return this.method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable e2 = e.getTargetException();
            throw Utils.throwableUnwrap(e2);
        }
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        Invocation inv = new Invocation(obj, args, this, this.interceptors);
        return inv.invoke();
    }
}

