/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.util.PropUtil;
import org.noear.solon.core.util.ResourceUtil;

public class Props
extends Properties {
    private ClassLoader classLoader;
    private Map<String, String> tempPropMap = new TreeMap<String, String>();
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public Props() {
    }

    public Props(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Props(Properties defaults) {
        super(defaults);
    }

    public Props(Map<String, String> data) {
        super.putAll(data);
    }

    @Override
    public synchronized int size() {
        if (this.defaults == null) {
            return super.size();
        }
        return super.size() + this.defaults.size();
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String getByKeys(String ... keys) {
        for (String key : keys) {
            String tmp = this.get(key);
            if (!Utils.isNotEmpty(tmp)) continue;
            return tmp;
        }
        return null;
    }

    public String getByExpr(String expr) {
        return this.getByExpr(expr, null);
    }

    protected String getByExpr(String expr, Properties props) {
        return PropUtil.getByExp(this, props, expr);
    }

    public String getByParse(String tml) {
        return this.getByParse(tml, null);
    }

    protected String getByParse(String tml, Properties props) {
        return PropUtil.getByTml(this, props, tml);
    }

    protected String getByParse(String tml, Properties props, boolean useDef) {
        return PropUtil.getByTml(this, props, tml, useDef);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDefault(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDefault(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDefault(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDefault(key, def, Double::parseDouble);
    }

    public <T> T getOrDefault(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public <T> T getBean(String keyStarts, Class<T> clz) {
        Props props = this.getProp(keyStarts);
        return PropsConverter.global().convert(props, clz);
    }

    public <T> T getBean(Class<T> clz) {
        return PropsConverter.global().convert(this, clz);
    }

    public <T> T bindTo(T obj) {
        PropsConverter.global().convert(this, obj, null, null);
        return obj;
    }

    public Props getProp(String keyStarts) {
        if (Utils.isEmpty(keyStarts)) {
            return this;
        }
        Props prop = new Props();
        this.doFind(keyStarts, (key, val) -> {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            prop.put(key, val);
        });
        return prop;
    }

    public Map<String, Props> getGroupedProp(String keyStarts) {
        Props rootProps = this.getProp(keyStarts);
        HashSet<String> groups = new HashSet<String>();
        for (Object key : rootProps.keySet()) {
            if (!(key instanceof String)) continue;
            groups.add(((String)key).split("\\.")[0]);
        }
        HashMap<String, Props> groupProps = new HashMap<String, Props>();
        for (String group : groups) {
            Props tmp = rootProps.getProp(group);
            groupProps.put(group, tmp);
        }
        return groupProps;
    }

    public Props getPropByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.getProp(name);
    }

    @Deprecated
    public NvMap getXmap(String keyStarts) {
        NvMap map = new NvMap();
        this.doFind(keyStarts + ".", map::put);
        return map;
    }

    public Map<String, String> getMap(String keyStarts) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.doFind(keyStarts, (key, val) -> {
            if (key.startsWith(".")) {
                key = key.substring(1);
            }
            map.put((String)key, (String)val);
        });
        return map;
    }

    public List<String> getList(String keyStarts) {
        TreeMap sortMap = new TreeMap();
        this.doFind(keyStarts + "[", (k, v) -> sortMap.put(k, v));
        return new ArrayList<String>(sortMap.values());
    }

    protected void doFind(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts;
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                String key = keyStr.substring(idx2);
                setFun.accept(key, (String)v);
                if (key.contains("-")) {
                    String camelKey = this.buildCamelKey(key);
                    setFun.accept(camelKey, (String)v);
                }
            }
        }));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        super.forEach(action);
        if (this.defaults != null) {
            this.defaults.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!super.containsKey(k)) {
                    action.accept(k, v);
                }
            }));
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public synchronized void putIfNotNull(Object key, Object value) {
        if (key != null && value != null) {
            this.put(key, value);
        }
    }

    public void loadAdd(String name) {
        this.loadAdd(ResourceUtil.getResource(this.classLoader, name));
    }

    public void loadAdd(Import anno) {
        if (anno == null) {
            return;
        }
        for (String uri : anno.profiles()) {
            uri = this.getByParse(uri);
            this.loadAdd(ResourceUtil.findResource(this.classLoader, uri));
        }
        for (String uri : anno.profilesIfAbsent()) {
            uri = this.getByParse(uri);
            this.loadAddIfAbsent(ResourceUtil.findResource(this.classLoader, uri));
        }
    }

    @Deprecated
    public void loadAdd(PropertySource anno) {
        if (anno == null) {
            return;
        }
        for (String uri : anno.value()) {
            uri = this.getByParse(uri);
            this.loadAdd(ResourceUtil.findResource(this.classLoader, uri));
        }
    }

    public void loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
    }

    public void loadAdd(Properties props) {
        this.loadAddDo(props, false, false);
    }

    public void loadAddIfAbsent(String name) {
        this.loadAddIfAbsent(ResourceUtil.getResource(this.classLoader, name));
    }

    public void loadAddIfAbsent(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAddIfAbsent(props);
        }
    }

    public void loadAddIfAbsent(Properties props) {
        this.loadAddDo(props, false, true);
    }

    protected void loadAddDo(Properties props, boolean toSystem, boolean addIfAbsent) {
        this.loadAddDo(props, toSystem, addIfAbsent, false);
        this.reviseDo(false);
    }

    protected void loadAddDo(Properties props, boolean toSystem, boolean addIfAbsent, boolean isEnd) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String key;
                Object k1 = kv.getKey();
                Object v1 = kv.getValue();
                if (addIfAbsent && this.containsKey(k1) || !(k1 instanceof String) || Utils.isEmpty(key = (String)k1)) continue;
                if (v1 instanceof String) {
                    String valExp = (String)v1;
                    if ((v1 = this.getByParse(valExp, props, isEnd)) == null) {
                        if (!isEnd) {
                            this.tempPropMap.put(key, valExp);
                        }
                    } else {
                        this.tempPropMap.remove(key);
                    }
                }
                if (v1 == null) continue;
                if (toSystem) {
                    System.getProperties().put(k1, v1);
                }
                this.put(k1, v1);
                if (!key.contains("-")) continue;
                String camelKey = this.buildCamelKey(key);
                this.put(camelKey, v1);
            }
        }
    }

    public void complete() {
        this.reviseDo(true);
    }

    protected void reviseDo(boolean isEnd) {
        if (this.tempPropMap.size() == 0) {
            return;
        }
        Properties tempProps = new Properties();
        tempProps.putAll(this.tempPropMap);
        this.loadAddDo(tempProps, false, false, isEnd);
        if (isEnd && this.tempPropMap.size() > 0) {
            throw new IllegalStateException("Config verification failed: " + this.tempPropMap);
        }
    }

    private String buildCamelKey(String key) {
        String[] ss = key.split("-");
        StringBuilder sb = new StringBuilder(key.length());
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            if (ss[i].length() > 1) {
                sb.append(ss[i].substring(0, 1).toUpperCase()).append(ss[i].substring(1));
                continue;
            }
            sb.append(ss[i].toUpperCase());
        }
        return sb.toString();
    }
}

