/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Properties;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.bean.InitializingBean;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.lang.Nullable;

public class PluginEntity {
    private String className;
    private ClassLoader classLoader;
    private int priority = 0;
    private Plugin plugin;
    private Properties props;

    public PluginEntity(ClassLoader classLoader, String className, Properties props) {
        this.classLoader = classLoader;
        this.className = className;
        this.props = props;
    }

    @Deprecated
    public PluginEntity(Plugin plugin) {
        this.plugin = plugin;
    }

    @Deprecated
    public PluginEntity(Plugin plugin, int priority) {
        this.plugin = plugin;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Nullable
    public Plugin getPlugin() {
        return this.plugin;
    }

    public Properties getProps() {
        return this.props;
    }

    public String getClassName() {
        return this.className;
    }

    public void init(AopContext context) {
        this.initInstance(context);
    }

    public void start(AopContext context) {
        if (this.plugin != null) {
            try {
                this.plugin.start(context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Plugin start failed", e);
            }
        }
    }

    public void prestop() {
        if (this.plugin != null) {
            try {
                this.plugin.prestop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void stop() {
        if (this.plugin != null) {
            try {
                this.plugin.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void initInstance(AopContext context) {
        if (this.plugin == null && this.classLoader != null) {
            this.plugin = (Plugin)ClassUtil.tryInstance(this.classLoader, this.className);
            if (this.plugin == null) {
                LogUtil.global().warn("The configured plugin cannot load: " + this.className);
            } else if (this.plugin instanceof InitializingBean) {
                try {
                    ((InitializingBean)((Object)this.plugin)).afterInjection();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

