/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Utils;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Options;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.PathUtil;

public class HandlerLoader
extends HandlerAide {
    protected BeanWrap bw;
    protected Render bRender;
    protected Mapping bMapping;
    protected String bPath;
    protected boolean bRemoting;
    protected boolean allowMapping;

    public HandlerLoader(BeanWrap wrap) {
        this.bMapping = wrap.clz().getAnnotation(Mapping.class);
        if (this.bMapping == null) {
            this.initDo(wrap, null, wrap.remoting(), null, true);
        } else {
            String bPath = Utils.annoAlias(this.bMapping.value(), this.bMapping.path());
            this.initDo(wrap, bPath, wrap.remoting(), null, true);
        }
    }

    public HandlerLoader(BeanWrap wrap, String mapping) {
        this.initDo(wrap, mapping, wrap.remoting(), null, true);
    }

    public HandlerLoader(BeanWrap wrap, String mapping, boolean remoting) {
        this.initDo(wrap, mapping, remoting, null, true);
    }

    public HandlerLoader(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        this.initDo(wrap, mapping, remoting, render, allowMapping);
    }

    private void initDo(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        this.bw = wrap;
        this.bRender = render;
        this.allowMapping = allowMapping;
        if (mapping != null) {
            this.bPath = mapping;
        }
        this.bRemoting = remoting;
    }

    public String mapping() {
        return this.bPath;
    }

    public void load(HandlerSlots slots) {
        this.load(this.bRemoting, slots);
    }

    public void load(boolean all, HandlerSlots slots) {
        if (Handler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActionDo(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(HandlerSlots slots) {
        if (this.bMapping == null) {
            throw new IllegalStateException(this.bw.clz().getName() + " No @Mapping!");
        }
        Handler handler = (Handler)this.bw.raw();
        Set<MethodType> v0 = MethodTypeUtil.findAndFill(new HashSet<MethodType>(), t -> this.bw.annotationGet(t) != null);
        if (v0.size() == 0) {
            v0 = new HashSet<MethodType>(Arrays.asList(this.bMapping.method()));
        }
        slots.add(this.bMapping, v0, handler);
    }

    protected Method[] findMethods(Class<?> clz) {
        return clz.getDeclaredMethods();
    }

    protected void loadActionDo(HandlerSlots slots, boolean all) {
        if (this.bPath == null) {
            this.bPath = "";
        }
        HashSet<MethodType> b_method = new HashSet<MethodType>();
        this.loadControllerAide(b_method);
        for (Method method : this.findMethods(this.bw.clz())) {
            String m_path;
            Mapping m_map = method.getAnnotation(Mapping.class);
            HashSet<MethodType> m_method = new HashSet<MethodType>();
            if (m_map == null && !Modifier.isPublic(method.getModifiers())) continue;
            MethodTypeUtil.findAndFill(m_method, t -> method.getAnnotation(t) != null);
            if (m_map != null) {
                m_path = Utils.annoAlias(m_map.value(), m_map.path());
                if (m_method.size() == 0) {
                    m_method.addAll(Arrays.asList(m_map.method()));
                }
            } else {
                m_path = method.getName();
                if (m_method.size() == 0) {
                    MethodTypeUtil.findAndFill(m_method, t -> this.bw.clz().getAnnotation(t) != null);
                }
                if (m_method.size() == 0) {
                    if (this.bMapping == null) {
                        m_method.add(MethodType.HTTP);
                    } else {
                        m_method.addAll(Arrays.asList(this.bMapping.method()));
                    }
                }
            }
            if (m_map == null && !all) continue;
            String newPath = PathUtil.mergePath(this.bPath, m_path);
            Action action = this.createAction(this.bw, method, m_map, newPath, this.bRemoting);
            this.loadActionAide(method, action, m_method);
            if (b_method.size() > 0 && !m_method.contains((Object)MethodType.HTTP) && !m_method.contains((Object)MethodType.ALL)) {
                m_method.addAll(b_method);
            }
            for (MethodType m1 : m_method) {
                if (m_map == null) {
                    slots.add(newPath, m1, (Handler)action);
                    continue;
                }
                slots.add(newPath, m1, (Handler)action);
            }
        }
    }

    protected void loadControllerAide(Set<MethodType> methodSet) {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (anno instanceof Before) {
                HandlerLoader.addDo(((Before)anno).value(), b -> this.before((Handler)this.bw.context().getBeanOrNew(b)));
                continue;
            }
            if (anno instanceof After) {
                HandlerLoader.addDo(((After)anno).value(), f -> this.after((Handler)this.bw.context().getBeanOrNew(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    HandlerLoader.addDo(((Before)anno2).value(), b -> this.before((Handler)this.bw.context().getBeanOrNew(b)));
                    continue;
                }
                if (anno2 instanceof After) {
                    HandlerLoader.addDo(((After)anno2).value(), f -> this.after((Handler)this.bw.context().getBeanOrNew(f)));
                    continue;
                }
                if (!(anno2 instanceof Options)) continue;
                methodSet.add(MethodType.OPTIONS);
            }
        }
    }

    protected void loadActionAide(Method method, Action action, Set<MethodType> methodSet) {
        for (Annotation anno : method.getAnnotations()) {
            if (anno instanceof Before) {
                HandlerLoader.addDo(((Before)anno).value(), b -> action.before((Handler)this.bw.context().getBeanOrNew(b)));
                continue;
            }
            if (anno instanceof After) {
                HandlerLoader.addDo(((After)anno).value(), f -> action.after((Handler)this.bw.context().getBeanOrNew(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    HandlerLoader.addDo(((Before)anno2).value(), b -> action.before((Handler)this.bw.context().getBeanOrNew(b)));
                    continue;
                }
                if (anno2 instanceof After) {
                    HandlerLoader.addDo(((After)anno2).value(), f -> action.after((Handler)this.bw.context().getBeanOrNew(f)));
                    continue;
                }
                if (!(anno2 instanceof Options) || methodSet.contains((Object)MethodType.HTTP) || methodSet.contains((Object)MethodType.ALL)) continue;
                methodSet.add(MethodType.OPTIONS);
            }
        }
    }

    protected Action createAction(BeanWrap bw, Method method, Mapping mp, String path, boolean remoting) {
        if (this.allowMapping) {
            return new Action(bw, this, method, mp, path, remoting, this.bRender);
        }
        return new Action(bw, this, method, null, path, remoting, this.bRender);
    }

    private static <T> void addDo(T[] ary, ConsumerEx<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.accept(t);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

