/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.annotation.ProxyComponent;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.annotation.ServerEndpoint;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.bean.InitializingBean;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.util.BiConsumerEx;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConditionUtil;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarGather;
import org.noear.solon.core.wrap.VarHolderOfParam;

public class AopContext
extends BeanContainer {
    private final Set<RankEntity<LifecycleBean>> lifecycleBeans = new HashSet<RankEntity<LifecycleBean>>();
    private final Map<Method, MethodWrap> methodCached = new HashMap<Method, MethodWrap>();
    private final Set<Class<?>> beanCreatedCached = new HashSet();
    private boolean started;

    public AopContext() {
        this(null, null);
    }

    public AopContext(ClassLoader classLoader, Props props) {
        super(classLoader, props);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodWrap methodGet(Method method) {
        MethodWrap mw = this.methodCached.get(method);
        if (mw == null) {
            Method method2 = method;
            synchronized (method2) {
                mw = this.methodCached.get(method);
                if (mw == null) {
                    mw = new MethodWrap(this, method);
                    this.methodCached.put(method, mw);
                }
            }
        }
        return mw;
    }

    @Override
    public void clear() {
        super.clear();
        this.methodCached.clear();
        this.beanCreatedCached.clear();
        this.lifecycleBeans.clear();
        this.started = false;
    }

    @Override
    protected BeanWrap wrapCreate(Class<?> type, Object bean, String name) {
        return new BeanWrap(this, type, bean, name);
    }

    public AopContext copy() {
        return this.copy(null, null);
    }

    public AopContext copy(ClassLoader classLoader, Props props) {
        AopContext tmp = new AopContext(classLoader, props);
        this.copyTo(tmp);
        return tmp;
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            this.cfg().loadAdd(clz.getAnnotation(PropertySource.class));
            for (Annotation a1 : clz.getAnnotations()) {
                if (a1 instanceof Import) {
                    this.beanImport((Import)a1);
                    continue;
                }
                this.beanImport(a1.annotationType().getAnnotation(Import.class));
            }
            this.beanInjectProperties(clz, bw.raw());
            for (Method m : ClassWrap.get(bw.clz()).getMethods()) {
                Bean ma = m.getAnnotation(Bean.class);
                if (ma == null) continue;
                this.tryCreateBeanOfMethod(bw, m, ma);
            }
            this.addBeanShape(clz, bw, clz);
            this.beanRegisterSup0(bw);
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.addBeanShape(clz, bw, clz);
            this.beanRegister(bw, beanName, anno.typed());
            this.beanExtract(bw);
            if (bw.singleton()) {
                EventBus.push(bw.raw());
                this.wrapPublish(bw);
            }
        });
        this.beanBuilderAdd(ProxyComponent.class, (clz, bw, anno) -> {
            throw new IllegalStateException("Missing plugin dependency: 'solon.proxy'");
        });
        this.beanBuilderAdd(Remoting.class, (clz, bw, anno) -> {
            bw.remotingSet(true);
            this.beanRegister(bw, "", false);
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> new HandlerLoader(bw).load(Solon.app()));
        this.beanBuilderAdd(ServerEndpoint.class, (clz, wrap, anno) -> {
            if (Listener.class.isAssignableFrom(clz)) {
                Listener l = (Listener)wrap.raw();
                Solon.app().router().add(Utils.annoAlias(anno.value(), anno.path()), anno.method(), l);
            }
        });
        this.beanInjectorAdd(Inject.class, (fwT, anno) -> this.beanInject(fwT, anno.value(), anno.required(), anno.autoRefreshed()));
    }

    private void addBeanShape(Class<?> clz, BeanWrap bw, AnnotatedElement annoEl) {
        Mapping mapping;
        if (Plugin.class.isAssignableFrom(clz)) {
            Solon.app().plug((Plugin)bw.raw());
            LogUtil.global().warn("'Plugin' will be deprecated as a component, please use 'LifecycleBean'");
            return;
        }
        if (LifecycleBean.class.isAssignableFrom(clz)) {
            this.lifecycle(bw.index(), (LifecycleBean)bw.raw());
            return;
        }
        if (EventListener.class.isAssignableFrom(clz)) {
            this.addEventListener(clz, bw);
            return;
        }
        if (LoadBalance.Factory.class.isAssignableFrom(clz)) {
            Bridge.upstreamFactorySet((LoadBalance.Factory)bw.raw());
        }
        if (Handler.class.isAssignableFrom(clz) && (mapping = annoEl.getAnnotation(Mapping.class)) != null) {
            Handler handler = (Handler)bw.raw();
            Set<MethodType> v0 = MethodTypeUtil.findAndFill(new HashSet<MethodType>(), t -> annoEl.getAnnotation(t) != null);
            if (v0.size() == 0) {
                v0 = new HashSet<MethodType>(Arrays.asList(mapping.method()));
            }
            Solon.app().add(mapping, v0, handler);
        }
        if (Filter.class.isAssignableFrom(clz)) {
            Solon.app().filter(bw.index(), (Filter)bw.raw());
        }
        if (RouterInterceptor.class.isAssignableFrom(clz)) {
            Solon.app().routerInterceptor(bw.index(), (RouterInterceptor)bw.raw());
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(clz, EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.subscribe(ets[0], (EventListener)bw.raw());
        }
    }

    public void beanExtract(BeanWrap bw) {
        if (bw == null) {
            return;
        }
        if (this.beanExtractors.size() == 0) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(bw.clz());
        for (Method m : clzWrap.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                BeanExtractor be = (BeanExtractor)this.beanExtractors.get(a.annotationType());
                if (be == null) continue;
                try {
                    be.doExtract(bw, m, a);
                }
                catch (Throwable e) {
                    e = Utils.throwableUnwrap(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        if (obj instanceof InitializingBean) {
            ArrayList<FieldWrap> fwList = new ArrayList<FieldWrap>();
            for (Map.Entry<String, FieldWrap> entry : clzWrap.getFieldAllWraps().entrySet()) {
                Annotation[] annS = entry.getValue().annoS;
                if (annS.length <= 0) continue;
                fwList.add(entry.getValue());
            }
            if (fwList.size() == 0) {
                RunUtil.runOrThrow(() -> ((InitializingBean)obj).afterInjection());
            } else {
                VarGather gather = new VarGather(fwList.size(), args2 -> RunUtil.runOrThrow(() -> ((InitializingBean)obj).afterInjection()));
                for (FieldWrap fw : fwList) {
                    VarHolder varH = fw.holder(this, obj, gather);
                    gather.add(varH);
                    this.tryInject(varH, fw.annoS);
                }
            }
        } else {
            for (Map.Entry<String, FieldWrap> kv : clzWrap.getFieldAllWraps().entrySet()) {
                Annotation[] annotationArray = kv.getValue().annoS;
                if (annotationArray.length <= 0) continue;
                VarHolder varH = kv.getValue().holder(this, obj, null);
                this.tryInject(varH, annotationArray);
            }
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> clz : anno.value()) {
                this.beanMake(clz);
            }
            for (String pkg : anno.scanPackages()) {
                this.beanScan(pkg);
            }
            for (Class<?> src : anno.scanPackageClasses()) {
                this.beanScan(src);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(this.getClassLoader(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace("/", "."));
            if (clz != null) {
                this.tryCreateBeanOfClass(clz);
            }
        });
    }

    public BeanWrap beanMake(Class<?> clz) {
        if (!ConditionUtil.test(this, clz)) {
            return null;
        }
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean0(bw.clz(), (bb, a) -> bb.doBuild(bw.clz(), bw, a));
        this.putWrap(clz, bw);
        return bw;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector bi = (BeanInjector)this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.doInject(varH, a);
            return;
        }
        varH.setValue(null);
    }

    protected void tryCreateBeanOfMethod(BeanWrap bw, Method m, Bean ma) throws Exception {
        Condition mc = m.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissing(mc)) {
            this.lifecycle(() -> this.tryCreateBeanOfMethod0(bw, m, ma, mc));
        } else {
            this.tryCreateBeanOfMethod0(bw, m, ma, mc);
        }
    }

    private void tryCreateBeanOfMethod0(BeanWrap bw, Method m, Bean ma, Condition mc) throws Exception {
        if (!ConditionUtil.test(this, mc)) {
            return;
        }
        m.setAccessible(true);
        MethodWrap mWrap = this.methodGet(m);
        this.tryBuildBean(ma, mWrap, bw);
    }

    protected void tryCreateBeanOfClass(Class<?> clz) {
        Condition cc = clz.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissing(cc)) {
            this.lifecycle(() -> this.tryCreateBeanOfClass0(clz, cc));
        } else {
            this.tryCreateBeanOfClass0(clz, cc);
        }
    }

    private void tryCreateBeanOfClass0(Class<?> clz, Condition cc) {
        if (!ConditionUtil.test(this, cc)) {
            return;
        }
        this.tryCreateBean0(clz, (bb, a) -> {
            BeanWrap bw = this.wrap(clz);
            bb.doBuild(clz, bw, a);
            this.putWrap(clz, bw);
        });
    }

    private void tryCreateBean0(Class<?> clz, BiConsumerEx<BeanBuilder, Annotation> consumer) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            if (this.beanCreatedCached.contains(clz)) {
                return;
            }
            this.beanCreatedCached.add(clz);
            for (Annotation a : annS) {
                BeanBuilder builder = (BeanBuilder)this.beanBuilders.get(a.annotationType());
                if (builder == null) continue;
                try {
                    consumer.accept(builder, a);
                }
                catch (Throwable e) {
                    e = Utils.throwableUnwrap(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    protected void tryBuildBean(Bean anno, MethodWrap mWrap, BeanWrap bw) throws Exception {
        int size2 = mWrap.getParamWraps().length;
        if (size2 == 0) {
            this.tryBuildBeanDo(anno, mWrap, bw, new Object[0]);
        } else {
            VarGather gather = new VarGather(size2, args2 -> RunUtil.runOrThrow(() -> this.tryBuildBeanDo(anno, mWrap, bw, (Object[])args2)));
            for (ParamWrap pw : mWrap.getParamWraps()) {
                VarHolderOfParam varH = new VarHolderOfParam(bw.context(), pw.getParameter(), gather);
                gather.add(varH);
                Annotation[] annoS = pw.getParameter().getDeclaredAnnotations();
                if (annoS.length == 0) {
                    this.beanInject(varH, null);
                    continue;
                }
                this.tryInject(varH, annoS);
            }
        }
    }

    protected void tryBuildBeanDo(Bean anno, MethodWrap mWrap, BeanWrap bw, Object[] args) throws Exception {
        Object raw = mWrap.invoke(bw.raw(), args);
        this.tryBuildBean0(mWrap, anno, raw);
    }

    protected void tryBuildBean0(MethodWrap mWrap, Bean anno, Object raw) {
        if (raw != null) {
            Class<?> beanClz = mWrap.getReturnType();
            Type beanGtp = mWrap.getGenericReturnType();
            BeanWrap m_bw = null;
            if (raw instanceof BeanWrap) {
                m_bw = (BeanWrap)raw;
            } else {
                EventBus.push(raw);
                m_bw = this.wrapCreate(beanClz, raw, null);
            }
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            m_bw.nameSet(beanName);
            m_bw.tagSet(anno.tag());
            m_bw.typedSet(anno.typed());
            m_bw.indexSet(anno.index());
            this.addBeanShape(m_bw.clz(), m_bw, mWrap.getMethod());
            this.beanRegister(m_bw, beanName, anno.typed());
            if (beanGtp instanceof ParameterizedType) {
                this.putWrap(beanGtp.getTypeName(), m_bw);
            }
            this.wrapPublish(m_bw);
        }
    }

    @Deprecated
    public void beanOnloaded(Consumer<AopContext> fun) {
        this.beanOnloaded(0, fun::accept);
    }

    @Deprecated
    public void beanOnloaded(int index, Consumer<AopContext> fun) {
        try {
            this.lifecycle(index, () -> fun.accept(this));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public void beanLoaded() {
        this.start();
    }

    public void lifecycle(LifecycleBean lifecycle) {
        this.lifecycle(0, lifecycle);
    }

    public void lifecycle(int index, LifecycleBean lifecycle) {
        this.lifecycleBeans.add(new RankEntity<LifecycleBean>(lifecycle, index));
        if (this.started) {
            RunUtil.runOrThrow(lifecycle::start);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        try {
            ArrayList<RankEntity<LifecycleBean>> beans = new ArrayList<RankEntity<LifecycleBean>>(this.lifecycleBeans);
            beans.sort(Comparator.comparingInt(f -> f.index));
            for (RankEntity rankEntity : beans) {
                ((LifecycleBean)rankEntity.target).start();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("AopContext start failed", e);
        }
    }

    public void stop() {
        this.started = false;
        ArrayList<RankEntity<LifecycleBean>> beans = new ArrayList<RankEntity<LifecycleBean>>(this.lifecycleBeans);
        beans.sort(Comparator.comparingInt(f -> f.index));
        for (RankEntity rankEntity : beans) {
            try {
                ((LifecycleBean)rankEntity.target).stop();
            }
            catch (Throwable throwable) {}
        }
    }
}

