/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Signal;
import org.noear.solon.core.event.AppBeanLoadEndEvent;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.AppPluginInitEndEvent;
import org.noear.solon.core.event.AppPluginLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextPathFilter;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.route.RouterWrapper;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;

public class SolonApp
extends RouterWrapper {
    private final SolonProps _cfg;
    private final AopContext _context;
    private final Class<?> _source;
    private final long _startupTime;
    protected boolean stopped = false;
    private final Map<Integer, Signal> signals = new LinkedHashMap<Integer, Signal>();
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private Handler _handler = null;
    private Map<Integer, Handler> _statusHandlers = new HashMap<Integer, Handler>();
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = false;
    private boolean _enableWebSocketMvc = true;
    private boolean _enableWebSocketD = false;
    private boolean _enableSocketD = false;
    private boolean _enableSocketMvc = true;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;
    private boolean _enableErrorAutoprint = true;
    private boolean _enableSessionState = true;
    private boolean _enableJarIsolation = false;

    @Override
    public AopContext context() {
        return this._context;
    }

    public SolonProps cfg() {
        return this._cfg;
    }

    protected SolonApp(Class<?> source, NvMap args) throws Exception {
        this._startupTime = System.currentTimeMillis();
        this._source = source;
        if (source == null) {
            throw new IllegalArgumentException("The startup class parameter('source') cannot be null");
        }
        if (source.getPackage() == null || Utils.isEmpty(source.getPackage().getName())) {
            throw new IllegalStateException("The startup class is missing package: " + source.getName());
        }
        this._cfg = new SolonProps().load(source, args);
        this._context = new AopContext(new JarClassLoader(JarClassLoader.global()), this._cfg);
        this.initRouter(this::doFilter);
        this._handler = this.routerHandler();
        this.enableJarIsolation(this._cfg.getBool("solon.extend.isolation", false));
    }

    protected void start(ConsumerEx<SolonApp> initialize) throws Throwable {
        this.initAwait();
        this.init();
        if (initialize != null) {
            initialize.accept(this);
        }
        this.run();
    }

    private void initAwait() throws Throwable {
        String addr = this.cfg().get("solon.start.ping");
        if (Utils.isNotEmpty(addr)) {
            try {
                while (true) {
                    if (Utils.ping(addr)) {
                        LogUtil.global().info("App: Start ping succeed: " + addr);
                        Thread.sleep(1000L);
                        break;
                    }
                    LogUtil.global().warn("App: Start ping failure: " + addr);
                    Thread.sleep(2000L);
                }
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void init() throws Throwable {
        List<ClassLoader> loaderList;
        String filterStr = this.cfg().extendFilter();
        if (Utils.isEmpty(filterStr)) {
            loaderList = ExtendLoader.load(this.cfg().extend(), false);
        } else {
            String[] filterS = filterStr.split(",");
            loaderList = ExtendLoader.load(this.cfg().extend(), false, path -> {
                for (String f : filterS) {
                    if (!path.contains(f)) continue;
                    return true;
                }
                return false;
            });
        }
        this.cfg().plugsScan(loaderList);
        if (Utils.isNotEmpty(this.cfg().serverContextPath())) {
            this.filter(-99, new ContextPathFilter(this.cfg().serverContextPath()));
        }
    }

    private void run() throws Throwable {
        int i;
        EventBus.pushTry(new AppInitEndEvent(this));
        List<PluginEntity> plugs = this.cfg().plugs();
        int len = plugs.size();
        for (i = 0; i < len; ++i) {
            plugs.get(i).init(this.context());
        }
        EventBus.pushTry(new AppPluginInitEndEvent(this));
        LogUtil.global().info("App: Plugin starting");
        len = plugs.size();
        for (i = 0; i < len; ++i) {
            plugs.get(i).start(this.context());
        }
        EventBus.pushTry(new AppPluginLoadEndEvent(this));
        LogUtil.global().info("App: Bean scanning");
        this.importTry();
        if (this.source() != null) {
            this.context().beanScan(this.source());
        }
        EventBus.pushTry(new AppBeanLoadEndEvent(this));
        NvMap map = this.cfg().getXmap("solon.view.mapping");
        map.forEach((k, v) -> RenderManager.mapping("." + k, v));
        this.context().beanLoaded();
        EventBus.pushTry(new AppLoadEndEvent(this));
    }

    protected void importTry() {
        if (this._source == null) {
            return;
        }
        for (Annotation a1 : this._source.getAnnotations()) {
            if (a1 instanceof Import) {
                this.context().beanImport((Import)a1);
                continue;
            }
            this.context().beanImport(a1.annotationType().getAnnotation(Import.class));
        }
    }

    public void signalAdd(Signal instance) {
        this.signals.putIfAbsent(instance.port(), instance);
    }

    public Signal signalGet(int port) {
        return this.signals.get(port);
    }

    public Collection<Signal> signals() {
        return Collections.unmodifiableCollection(this.signals.values());
    }

    public ClassLoader classLoader() {
        return this.context().getClassLoader();
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    protected long elapsedTimes() {
        return System.currentTimeMillis() - this._startupTime;
    }

    public Class<?> source() {
        return this._source;
    }

    public void plug(Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin);
        p.init(this.context());
        p.start(this.context());
        this.cfg().plugs().add(p);
    }

    public void pluginAdd(int priority, Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin, priority);
        this.cfg().plugs().add(p);
        this.cfg().plugsSort();
    }

    public PluginEntity pluginPop(Class<?> pluginClz) {
        PluginEntity tmp = null;
        for (PluginEntity pe : this.cfg().plugs()) {
            if (!pluginClz.isInstance(pe.getPlugin())) continue;
            tmp = pe;
            break;
        }
        if (tmp != null) {
            this.cfg().plugs().remove(tmp);
        }
        return tmp;
    }

    public Handler handlerGet() {
        return this._handler;
    }

    public void handlerSet(Handler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryHandle(Context x) {
        block13: {
            try {
                ContextUtil.currentSet(x);
                if (this.stopped) {
                    x.status(503);
                } else {
                    this.chainManager().doFilter(x);
                    if (!x.getHandled() && x.status() <= 200 && x.mainHandler() == null) {
                        x.status(404);
                    }
                }
                this.doStatus(x);
            }
            catch (Throwable ex) {
                ex = Utils.throwableUnwrap(ex);
                EventBus.pushTry(ex);
                if (!x.getHandled() && x.status() < 400) {
                    x.status(500);
                }
                if (x.getRendered()) break block13;
                try {
                    if (!this.doStatus(x) && Solon.cfg().isDebugMode()) {
                        x.output(ex);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                ContextUtil.currentRemove();
            }
        }
    }

    protected void doFilter(Context x, FilterChain chain) throws Throwable {
        this._handler.handle(x);
    }

    protected boolean doStatus(Context x) throws Throwable {
        Handler h;
        if (x.status() >= 400 && this._statusHandlers.size() > 0 && (h = this._statusHandlers.get(x.status())) != null) {
            x.status(200);
            x.setHandled(true);
            h.handle(x);
            return true;
        }
        return false;
    }

    public <T> SolonApp onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public SolonApp onError(EventListener<Throwable> handler) {
        return this.onEvent(Throwable.class, handler);
    }

    public SolonApp onStatus(Integer code, Handler handler) {
        this._statusHandlers.put(code, handler);
        return this;
    }

    public void block() throws InterruptedException {
        Thread.currentThread().join();
    }

    public boolean enableHttp() {
        return this._enableHttp;
    }

    public SolonApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket;
    }

    public SolonApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableWebSocketMvc() {
        return this._enableWebSocketMvc;
    }

    public SolonApp enableWebSocketMvc(boolean enable) {
        this._enableWebSocketMvc = enable;
        return this;
    }

    public boolean enableWebSocketD() {
        return this._enableWebSocketD;
    }

    public SolonApp enableWebSocketD(boolean enable) {
        this._enableWebSocketD = enable;
        if (enable) {
            this._enableWebSocket = enable;
        }
        return this;
    }

    public boolean enableSocketD() {
        return this._enableSocketD;
    }

    public SolonApp enableSocketD(boolean enable) {
        this._enableSocketD = enable;
        return this;
    }

    public boolean enableSocketMvc() {
        return this._enableSocketMvc;
    }

    public SolonApp enableSocketMvc(boolean enable) {
        this._enableSocketMvc = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public SolonApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public SolonApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public SolonApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }

    public boolean enableErrorAutoprint() {
        return this._enableErrorAutoprint;
    }

    public void enableErrorAutoprint(boolean enable) {
        this._enableErrorAutoprint = enable;
    }

    public boolean enableSessionState() {
        return this._enableSessionState;
    }

    public SolonApp enableSessionState(boolean enable) {
        this._enableSessionState = enable;
        return this;
    }

    public boolean enableJarIsolation() {
        return this._enableJarIsolation;
    }

    private SolonApp enableJarIsolation(boolean enable) {
        this._enableJarIsolation = enable;
        return this;
    }
}

