/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.ScanUtil;

public class ResourceUtil {
    public static Collection<Class<?>> resolveClasses(String packExpr) {
        return ResourceUtil.resolveClasses(JarClassLoader.global(), packExpr);
    }

    public static Collection<Class<?>> resolveClasses(ClassLoader classLoader, String packExpr) {
        ArrayList clzList = new ArrayList();
        if (packExpr.indexOf("*") < 0 && packExpr.endsWith(".class")) {
            String className = packExpr.substring(0, packExpr.length() - 6);
            Class<?> clz = Utils.loadClass(classLoader, className);
            if (clz != null) {
                clzList.add(clz);
            }
            return clzList;
        }
        packExpr = packExpr.replace(".", "/");
        if (!(packExpr = packExpr.replace("/class", ".class")).endsWith(".class")) {
            packExpr = packExpr + "/*.class";
        }
        ResourceUtil.resolvePaths(classLoader, packExpr).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = Utils.loadClass(classLoader, className = className.replace("/", "."));
            if (clz != null) {
                clzList.add(clz);
            }
        });
        return clzList;
    }

    public static Collection<String> resolvePaths(String pathExpr) {
        return ResourceUtil.resolvePaths(JarClassLoader.global(), pathExpr);
    }

    public static Collection<String> resolvePaths(ClassLoader classLoader, String pathExpr) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!pathExpr.contains("/*")) {
            paths.add(pathExpr);
            return paths;
        }
        int dirIdx = pathExpr.indexOf("/*");
        if (dirIdx < 1) {
            throw new IllegalArgumentException("Expressions without a first-level directory are not supported: " + pathExpr);
        }
        String dir = pathExpr.substring(0, dirIdx);
        int sufIdx = pathExpr.lastIndexOf(".");
        String suf = null;
        if (sufIdx > 0 && (suf = pathExpr.substring(sufIdx)).contains("*")) {
            sufIdx = -1;
            suf = null;
        }
        int sufIdx2 = sufIdx;
        String suf2 = suf;
        String expr = pathExpr.replaceAll("/\\*\\.", "/[^\\./]+\\.");
        expr = expr.replaceAll("/\\*\\*/", "(/[^/]*)*/");
        expr = expr.replaceAll("/\\*/", "/[^/]+/");
        Pattern pattern = Pattern.compile(expr);
        ScanUtil.scan(classLoader, dir, n -> {
            if (sufIdx2 > 0) {
                return n.endsWith(suf2);
            }
            return true;
        }).forEach(uri -> {
            if (pattern.matcher((CharSequence)uri).find()) {
                paths.add((String)uri);
            }
        });
        return paths;
    }
}

