/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PropsConverter;

public class Props
extends Properties {
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public Props() {
    }

    public Props(Properties defaults) {
        super(defaults);
    }

    @Override
    public synchronized int size() {
        if (this.defaults == null) {
            return super.size();
        }
        return super.size() + this.defaults.size();
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String getByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.get(name);
    }

    public String getByParse(String expr) {
        if (Utils.isEmpty(expr)) {
            return expr;
        }
        int start = expr.indexOf("${");
        if (start < 0) {
            return expr;
        }
        int end = expr.indexOf("}");
        String name = expr.substring(start + 2, end);
        String value = this.get(name);
        return expr.substring(0, start) + value + expr.substring(end + 1);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public boolean getBool(String key, boolean def) {
        return this.getOrDef(key, def, Boolean::parseBoolean);
    }

    public int getInt(String key, int def) {
        return this.getOrDef(key, def, Integer::parseInt);
    }

    public long getLong(String key, long def) {
        return this.getOrDef(key, def, Long::parseLong);
    }

    public Double getDouble(String key, double def) {
        return this.getOrDef(key, def, Double::parseDouble);
    }

    private <T> T getOrDef(String key, T def, Function<String, T> convert) {
        String temp = this.get(key);
        if (Utils.isEmpty(temp)) {
            return def;
        }
        return convert.apply(temp);
    }

    public <T> T getBean(String keyStarts, Class<T> type) {
        Props props = this.getProp(keyStarts);
        return PropsConverter.global().convert(props, null, type);
    }

    public Props getProp(String keyStarts) {
        Props prop = new Props();
        this.doFind(keyStarts + ".", prop::put);
        return prop;
    }

    public Props getPropByExpr(String expr) {
        String name = expr;
        if (name.startsWith("${") && name.endsWith("}")) {
            name = expr.substring(2, name.length() - 1);
        }
        return this.getProp(name);
    }

    public NvMap getXmap(String keyStarts) {
        NvMap map = new NvMap();
        this.doFind(keyStarts + ".", map::put);
        return map;
    }

    public List<String> getList(String keyStarts) {
        ArrayList<String> ary = new ArrayList<String>();
        this.doFind(keyStarts + "[", (k, v) -> ary.add((String)v));
        return ary;
    }

    private void doFind(String keyStarts, BiConsumer<String, String> setFun) {
        String key2 = keyStarts;
        int idx2 = key2.length();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String keyStr;
            if (k instanceof String && v instanceof String && (keyStr = (String)k).startsWith(key2)) {
                String key = keyStr.substring(idx2);
                setFun.accept(key, (String)v);
                if (key.contains("-")) {
                    String[] ss = key.split("-");
                    StringBuilder sb = new StringBuilder(key.length());
                    sb.append(ss[0]);
                    for (int i = 1; i < ss.length; ++i) {
                        if (ss[i].length() > 1) {
                            sb.append(ss[i].substring(0, 1).toUpperCase()).append(ss[i].substring(1));
                            continue;
                        }
                        sb.append(ss[i].toUpperCase());
                    }
                    setFun.accept(sb.toString(), (String)v);
                }
            }
        }));
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        if (this.defaults == null) {
            super.forEach(action);
        } else {
            this.defaults.forEach(action);
            super.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!this.defaults.containsKey(k)) {
                    action.accept(k, v);
                }
            }));
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public void loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
    }

    public void loadAdd(Properties props) {
        this.loadAddDo(props, false);
    }

    protected void loadAddDo(Properties props, boolean toSystem) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String key;
                Object k1 = kv.getKey();
                Object v1 = kv.getValue();
                if (!(k1 instanceof String) || Utils.isEmpty(key = (String)k1)) continue;
                if (v1 instanceof String) {
                    int symEnd;
                    String v1Str = (String)v1;
                    int symStart = 0;
                    while ((symStart = v1Str.indexOf("${", symStart)) >= 0 && (symEnd = v1Str.indexOf("}", symStart + 1)) > symStart) {
                        String tmpK = v1Str.substring(symStart + 2, symEnd);
                        String tmpV2 = props.getProperty(tmpK);
                        if (tmpV2 == null) {
                            tmpV2 = this.getProperty(tmpK);
                        }
                        if (tmpV2 == null) {
                            symStart = symEnd;
                            continue;
                        }
                        if (symStart > 0) {
                            tmpV2 = v1Str.substring(0, symStart) + tmpV2;
                        }
                        symStart = tmpV2.length();
                        v1Str = tmpV2 + v1Str.substring(symEnd + 1);
                    }
                    v1 = v1Str;
                }
                if (v1 == null) continue;
                if (toSystem) {
                    System.getProperties().put(k1, v1);
                }
                this.put(k1, v1);
            }
        }
    }
}

