/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.util.ConvertUtil;

public abstract class BeanContainer {
    protected Props props;
    private final Map<Class<?>, BeanWrap> beanWraps = new HashMap();
    private final Set<BeanWrap> beanWrapSet = new HashSet<BeanWrap>();
    private final Map<String, BeanWrap> beans = new HashMap<String, BeanWrap>();
    private final Map<Class<?>, Class<?>> clzMapping = new HashMap();
    protected final Map<Class<?>, BeanBuilder<?>> beanBuilders = new HashMap();
    protected final Map<Class<?>, BeanInjector<?>> beanInjectors = new HashMap();
    protected final Map<Class<?>, BeanExtractor<?>> beanExtractors = new HashMap();
    protected final Map<Class<?>, InterceptorEntity> beanInterceptors = new HashMap();
    protected final Set<SubscriberEntity> beanSubscribers = new LinkedHashSet<SubscriberEntity>();

    public Props getProps() {
        if (this.props == null) {
            return Solon.cfg();
        }
        return this.props;
    }

    public void clear() {
        this.beanWraps.clear();
        this.beanWrapSet.clear();
        this.beans.clear();
        this.clzMapping.clear();
    }

    public void copyTo(BeanContainer container) {
        this.beanBuilders.forEach((k, v) -> container.beanBuilders.putIfAbsent((Class<?>)k, (BeanBuilder<?>)v));
        this.beanInjectors.forEach((k, v) -> container.beanInjectors.putIfAbsent((Class<?>)k, (BeanInjector<?>)v));
        this.beanInterceptors.forEach((k, v) -> container.beanInterceptors.putIfAbsent((Class<?>)k, (InterceptorEntity)v));
        this.beanExtractors.forEach((k, v) -> container.beanExtractors.putIfAbsent((Class<?>)k, (BeanExtractor<?>)v));
    }

    public <T extends Annotation> void beanBuilderAdd(Class<T> anno, BeanBuilder<T> builder) {
        this.beanBuilders.put(anno, builder);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> anno, BeanInjector<T> injector) {
        this.beanInjectors.put(anno, injector);
    }

    public <T extends Annotation> void beanExtractorAdd(Class<T> anno, BeanExtractor<T> extractor) {
        this.beanExtractors.put(anno, extractor);
    }

    public <T extends Annotation> void beanAroundAdd(Class<T> anno, Interceptor interceptor, int index) {
        this.beanInterceptors.put(anno, new InterceptorEntity(index, interceptor));
    }

    public <T extends Annotation> void beanAroundAdd(Class<T> anno, Interceptor interceptor) {
        this.beanAroundAdd(anno, interceptor, 0);
    }

    public <T extends Annotation> InterceptorEntity beanAroundGet(Class<T> anno) {
        return this.beanInterceptors.get(anno);
    }

    public void beanSubscribe(Object nameOrType, Consumer<BeanWrap> callback) {
        if (nameOrType != null) {
            this.beanSubscribers.add(new SubscriberEntity(nameOrType, callback));
        }
    }

    public void beanNotice(Object nameOrType, BeanWrap wrap) {
        if (wrap.raw() == null) {
            return;
        }
        new ArrayList<SubscriberEntity>(this.beanSubscribers).forEach(s1 -> {
            if (s1.key.equals(nameOrType)) {
                s1.callback.accept(wrap);
            }
        });
    }

    public synchronized void putWrap(String name, BeanWrap wrap) {
        if (!Utils.isEmpty(name) && wrap.raw() != null && !this.beans.containsKey(name)) {
            this.beans.put(name, wrap);
            this.beanNotice(name, wrap);
        }
    }

    public synchronized void putWrap(Class<?> type, BeanWrap wrap) {
        if (type != null && wrap.raw() != null && !this.beanWraps.containsKey(type)) {
            this.beanWraps.put(type, wrap);
            this.beanWrapSet.add(wrap);
            this.beanNotice(type, wrap);
        }
    }

    public BeanWrap getWrap(Object nameOrType) {
        if (nameOrType instanceof String) {
            return this.beans.get(nameOrType);
        }
        return this.beanWraps.get(nameOrType);
    }

    public void getWrapAsyn(Object nameOrType, Consumer<BeanWrap> callback) {
        BeanWrap bw = this.getWrap(nameOrType);
        if (bw == null || bw.raw() == null) {
            this.beanSubscribe(nameOrType, callback);
        } else {
            callback.accept(bw);
        }
    }

    public <T> T getBean(Object nameOrType) {
        BeanWrap bw = this.getWrap(nameOrType);
        return bw == null ? null : (T)bw.get();
    }

    public BeanWrap wrap(Class<?> type, Object bean) {
        BeanWrap wrap = this.getWrap(type);
        if (wrap == null) {
            wrap = this.wrapCreate(type, bean);
        }
        return wrap;
    }

    protected abstract BeanWrap wrapCreate(Class<?> var1, Object var2);

    public void beanRegister(BeanWrap bw, String name, boolean typed) {
        HandlerLoader bww;
        if (Utils.isNotEmpty(name)) {
            this.putWrap(name, bw);
            if (!typed) {
                return;
            }
        }
        this.putWrap(bw.clz(), bw);
        this.putWrap(bw.clz().getName(), bw);
        this.beanRegisterSup0(bw);
        if (bw.remoting() && (bww = new HandlerLoader(bw)).mapping() != null) {
            bww.load(Solon.global());
        }
    }

    protected void beanRegisterSup0(BeanWrap bw) {
        Type[] list2;
        Class<?>[] list;
        for (Class<?> c : list = bw.clz().getInterfaces()) {
            if (c.getName().contains("java.")) continue;
            this.clzMapping.putIfAbsent(c, bw.clz());
            this.putWrap(c, bw);
        }
        for (Type t : list2 = bw.clz().getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            this.putWrap(t.getTypeName(), bw);
        }
    }

    public void beanInject(VarHolder varH, String name) {
        this.beanInject(varH, name, false);
    }

    protected void beanInject(VarHolder varH, String name, boolean autoRefreshed) {
        if (Utils.isEmpty(name)) {
            if (varH.getGenericType() != null) {
                this.getWrapAsyn(varH.getGenericType().getTypeName(), bw -> varH.setValue(bw.get()));
            } else {
                this.getWrapAsyn(varH.getType(), bw -> varH.setValue(bw.get()));
            }
        } else if (name.startsWith("${classpath:")) {
            String url = name.substring(12, name.length() - 1);
            Properties val2 = Utils.loadProperties(Utils.getResource(url));
            if (val2 == null) {
                throw new RuntimeException(name + "  failed to load!");
            }
            if (Properties.class == varH.getType()) {
                varH.setValue(val2);
            } else if (Map.class == varH.getType()) {
                HashMap val22 = new HashMap();
                val2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        val22.put((String)k, (String)v);
                    }
                }));
                varH.setValue(val22);
            } else {
                Object val23 = PropsConverter.global().convert(val2, null, varH.getType());
                varH.setValue(val23);
            }
        } else if (name.startsWith("${")) {
            String name2 = name.substring(2, name.length() - 1).trim();
            this.beanInjectConfig(varH, name2);
            if (autoRefreshed && varH.isField()) {
                this.getProps().onChange((key, val) -> {
                    if (key.startsWith(name2)) {
                        this.beanInjectConfig(varH, name2);
                    }
                });
            }
        } else {
            this.getWrapAsyn(name, bw -> {
                if (BeanWrap.class.isAssignableFrom(varH.getType())) {
                    varH.setValue(bw);
                } else {
                    varH.setValue(bw.get());
                }
            });
        }
    }

    protected void beanInjectProperties(Class<?> clz, BeanWrap bw) {
        Inject typeInj = clz.getAnnotation(Inject.class);
        if (typeInj != null && Utils.isNotEmpty(typeInj.value()) && typeInj.value().startsWith("${")) {
            Utils.injectProperties(bw.raw(), this.getProps().getPropByExpr(typeInj.value()));
        }
    }

    private void beanInjectConfig(VarHolder varH, String name) {
        if (Properties.class == varH.getType()) {
            Props val = this.getProps().getProp(name);
            varH.setValue(val);
        } else if (Map.class == varH.getType()) {
            NvMap val = this.getProps().getXmap(name);
            varH.setValue(val);
        } else if (List.class == varH.getType()) {
            List<String> ary = this.getProps().getList(name);
            varH.setValue(ary);
        } else {
            String def = null;
            int defIdx = name.indexOf(":");
            if (defIdx > 0) {
                def = name.length() > defIdx + 1 ? name.substring(defIdx + 1).trim() : "";
                name = name.substring(0, defIdx).trim();
            }
            String val = this.getProps().get(name);
            if (def != null && Utils.isEmpty(val)) {
                val = def;
            }
            if (val == null) {
                Props val0;
                Class<?> pt = varH.getType();
                if (!(pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive() || ((Properties)(val0 = this.getProps().getProp(name))).size() <= 0)) {
                    Object val2 = PropsConverter.global().convert(val0, null, pt);
                    varH.setValue(val2);
                }
            } else {
                Object val2 = ConvertUtil.to(varH.getType(), val);
                varH.setValue(val2);
            }
        }
    }

    @Note(value="\u904d\u5386bean\u5e93 (\u62ff\u5230\u7684\u662fbean\u5305\u88c5)")
    public void beanForeach(BiConsumer<String, BeanWrap> action) {
        this.beans.forEach(action);
    }

    @Note(value="\u904d\u5386bean\u5305\u88c5\u5e93")
    public void beanForeach(Consumer<BeanWrap> action) {
        new ArrayList<BeanWrap>(this.beanWrapSet).forEach(bw -> action.accept((BeanWrap)bw));
    }

    @Note(value="\u67e5\u627ebean\u5e93 (\u62ff\u5230\u7684\u662fbean\u5305\u88c5)")
    public List<BeanWrap> beanFind(BiPredicate<String, BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((String k, BeanWrap v) -> {
            if (condition.test((String)k, (BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        return list;
    }

    @Note(value="\u67e5\u627ebean\u5305\u88c5\u5e93")
    public List<BeanWrap> beanFind(Predicate<BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((BeanWrap v) -> {
            if (condition.test((BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        return list;
    }

    class SubscriberEntity {
        public Object key;
        public Consumer<BeanWrap> callback;

        public SubscriberEntity(Object key, Consumer<BeanWrap> callback) {
            this.key = key;
            this.callback = callback;
        }
    }
}

