/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.ScanUtil;

public final class SolonProps
extends Props {
    private NvMap args;
    private Class<?> source;
    private URL sourceLocation;
    private final List<PluginEntity> plugs = new ArrayList<PluginEntity>();
    private boolean isDebugMode;
    private boolean isDriftMode;
    private boolean isFilesMode;
    private boolean isWhiteMode;
    private boolean isSetupMode;
    private boolean isAloneMode;
    private String env;
    private Locale locale;
    private String extend;
    private String extendFilter;
    private String appName;
    private String appGroup;
    private String appTitle;
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();
    private int serverPort;

    public SolonProps() {
        super(System.getProperties());
    }

    public SolonProps load(Class<?> source, NvMap args) {
        this.args = args;
        this.source = source;
        this.sourceLocation = source.getProtectionDomain().getCodeSource().getLocation();
        this.args.forEach((? super K k, ? super V v) -> {
            if (k.contains(".")) {
                System.setProperty(k, v);
            }
        });
        Properties sysPropOrg = new Properties();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sysPropOrg.put(k, v)));
        this.loadInit(Utils.getResource("application.properties"), sysPropOrg);
        this.loadInit(Utils.getResource("application.yml"), sysPropOrg);
        this.loadInit(Utils.getResource("app.properties"), sysPropOrg);
        this.loadInit(Utils.getResource("app.yml"), sysPropOrg);
        this.loadEnv("solon.");
        this.env = this.getArg("env");
        if (Utils.isEmpty(this.env)) {
            this.env = this.getArg("profiles.active");
        }
        if (Utils.isNotEmpty(this.env)) {
            this.loadInit(Utils.getResource("application-" + this.env + ".properties"), sysPropOrg);
            this.loadInit(Utils.getResource("application-" + this.env + ".yml"), sysPropOrg);
            this.loadInit(Utils.getResource("app-" + this.env + ".properties"), sysPropOrg);
            this.loadInit(Utils.getResource("app-" + this.env + ".yml"), sysPropOrg);
        }
        this.isFilesMode = !this.sourceLocation.getPath().endsWith(".jar") && !this.sourceLocation.getPath().contains(".jar!/") && !this.sourceLocation.getPath().endsWith(".zip") && !this.sourceLocation.getPath().contains(".zip!/");
        this.isDebugMode = "1".equals(this.getArg("debug"));
        this.isSetupMode = "1".equals(this.getArg("setup"));
        this.isWhiteMode = "1".equals(this.getArg("white"));
        this.isDriftMode = "1".equals(this.getArg("drift"));
        this.isAloneMode = "1".equals(this.getArg("alone"));
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        this.extend = this.getArg("extend");
        this.extendFilter = this.getArg("extend.filter");
        String localeStr = this.getArg("locale");
        if (Utils.isNotEmpty(localeStr)) {
            this.locale = Utils.toLocale(localeStr);
            Locale.setDefault(this.locale);
        } else {
            this.locale = Locale.getDefault();
        }
        this.appName = this.getArg("app.name");
        this.appGroup = this.getArg("app.group");
        this.appTitle = this.getArg("app.title");
        return this;
    }

    private String getArg(String name) {
        return this.getArg(name, null);
    }

    private String getArg(String name, String def) {
        String tmp = (String)this.args.get(name);
        if (Utils.isEmpty(tmp)) {
            tmp = this.get("solon." + name);
        }
        if (Utils.isEmpty(tmp)) {
            return def;
        }
        return tmp;
    }

    public SolonProps loadEnv(String keyStarts) {
        System.getenv().forEach((? super K k, ? super V v) -> {
            if (k.startsWith(keyStarts)) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        return this;
    }

    public SolonProps loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
        return this;
    }

    public SolonProps loadAdd(String url) {
        return this.loadAdd(Utils.getResource(url));
    }

    public SolonProps loadAdd(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String key;
                Object k1 = kv.getKey();
                Object v1 = kv.getValue();
                if (!(k1 instanceof String) || Utils.isEmpty(key = (String)k1)) continue;
                if (v1 instanceof String) {
                    int symEnd;
                    String v1Str = (String)v1;
                    int symStart = 0;
                    while ((symStart = v1Str.indexOf("${", symStart)) >= 0 && (symEnd = v1Str.indexOf("}", symStart + 1)) > symStart) {
                        String tmpK = v1Str.substring(symStart + 2, symEnd);
                        String tmpV2 = props.getProperty(tmpK);
                        if (tmpV2 == null) {
                            tmpV2 = this.getProperty(tmpK);
                        }
                        if (tmpV2 == null) {
                            symStart = symEnd;
                            continue;
                        }
                        if (symStart > 0) {
                            tmpV2 = v1Str.substring(0, symStart) + tmpV2;
                        }
                        symStart = tmpV2.length();
                        v1Str = tmpV2 + v1Str.substring(symEnd + 1);
                    }
                    v1 = v1Str;
                }
                if (v1 == null) continue;
                System.getProperties().put(k1, v1);
                this.put(k1, v1);
            }
        }
        return this;
    }

    protected void loadInit(URL url, Properties sysPropOrg) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            if (props == null) {
                return;
            }
            for (Map.Entry<Object, Object> kv : sysPropOrg.entrySet()) {
                String key;
                if (!(kv.getKey() instanceof String) || Utils.isEmpty(key = (String)kv.getKey()) || !props.containsKey(key)) continue;
                props.put(key, kv.getValue());
            }
            this.loadAdd(props);
        }
    }

    protected void plugsScan(List<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            ScanUtil.scan(classLoader, "META-INF/solon", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(classLoader, k)).forEach((? super T url) -> this.plugsScanMapDo(classLoader, (URL)url));
        }
        this.plugsScanLoadDo(JarClassLoader.global(), this);
        this.plugsSort();
    }

    private void plugsScanMapDo(ClassLoader classLoader, URL url) {
        Props p = new Props(Utils.loadProperties(url));
        this.plugsScanLoadDo(classLoader, p);
    }

    private void plugsScanLoadDo(ClassLoader classLoader, Props p) {
        String pluginStr = p.get("solon.plugin");
        if (Utils.isNotEmpty(pluginStr)) {
            String[] plugins;
            int priority = p.getInt("solon.plugin.priority", 0);
            for (String clzName : plugins = pluginStr.trim().split(",")) {
                if (clzName.length() <= 0) continue;
                PluginEntity ent = new PluginEntity(classLoader, clzName.trim());
                ent.setPriority(priority);
                this.plugs.add(ent);
            }
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public Class<?> source() {
        return this.source;
    }

    public URL sourceLocation() {
        return this.sourceLocation;
    }

    public NvMap argx() {
        return this.args;
    }

    public List<PluginEntity> plugs() {
        return this.plugs;
    }

    public void plugsSort() {
        if (this.plugs.size() > 0) {
            this.plugs.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
    }

    public int serverPort() {
        if (this.serverPort == 0) {
            this.serverPort = this.getInt("server.port", 8080);
        }
        return this.serverPort;
    }

    public String env() {
        return this.env;
    }

    public Locale locale() {
        return this.locale;
    }

    public String extend() {
        return this.extend;
    }

    public String extendFilter() {
        return this.extendFilter;
    }

    public String appName() {
        return this.appName;
    }

    public String appGroup() {
        return this.appGroup;
    }

    public String appTitle() {
        return this.appTitle;
    }

    public String version() {
        return "1.6.25";
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isSetupMode() {
        return this.isSetupMode;
    }

    public boolean isFilesMode() {
        return this.isFilesMode;
    }

    public void isFilesMode(boolean isFilesMode) {
        this.isFilesMode = isFilesMode;
    }

    public boolean isDriftMode() {
        return this.isDriftMode;
    }

    public void isDriftMode(boolean isDriftMode) {
        this.isDriftMode = isDriftMode;
    }

    public boolean isAloneMode() {
        return this.isAloneMode;
    }

    public void isAloneMode(boolean isAloneMode) {
        this.isAloneMode = isAloneMode;
    }

    public boolean isWhiteMode() {
        return this.isWhiteMode;
    }

    public void isWhiteMode(boolean isWhiteMode) {
        this.isWhiteMode = isWhiteMode;
    }
}

