/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.util.PathAnalyzer;

public class PathUtil {
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public static String mergePath(String path1, String path2) {
        if (Utils.isEmpty(path1) || "**".equals(path1) || "/**".equals(path1)) {
            if (path2.startsWith("/")) {
                return path2;
            }
            return "/" + path2;
        }
        if (!path1.startsWith("/")) {
            path1 = "/" + path1;
        }
        if (Utils.isEmpty(path2)) {
            if (path1.endsWith("*")) {
                int idx = path1.lastIndexOf(47) + 1;
                if (idx < 1) {
                    return "/";
                }
                return path1.substring(0, idx) + path2;
            }
            return path1;
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        if (path1.endsWith("/")) {
            return path1 + path2;
        }
        if (path1.endsWith("*")) {
            int idx = path1.lastIndexOf(47) + 1;
            if (idx < 1) {
                return path2;
            }
            return path1.substring(0, idx) + path2;
        }
        return path1 + "/" + path2;
    }

    public static NvMap pathVarMap(String path, String expr) {
        NvMap _map = new NvMap();
        if (expr.indexOf("{") >= 0) {
            PathAnalyzer _pr;
            String path2 = null;
            try {
                path2 = URLDecoder.decode(path, Solon.encoding());
            }
            catch (Throwable ex) {
                path2 = path;
            }
            Matcher pm = _pkr.matcher(expr);
            ArrayList<String> _pks = new ArrayList<String>();
            while (pm.find()) {
                _pks.add(pm.group(1));
            }
            if (_pks.size() > 0 && (pm = (_pr = PathAnalyzer.get(expr)).matcher(path2)).find()) {
                int len = _pks.size();
                for (int i = 0; i < len; ++i) {
                    _map.put((String)_pks.get(i), pm.group(i + 1));
                }
            }
        }
        return _map;
    }
}

