/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Props;
import org.noear.solon.core.util.ResourceScaner;

public final class SolonProps
extends Props {
    private NvMap args;
    private Class<?> source;
    private URL sourceLocation;
    private List<PluginEntity> plugs = new ArrayList<PluginEntity>();
    private boolean isDebugMode;
    private boolean isDriftMode;
    private boolean isFilesMode;
    private boolean isWhiteMode;
    private boolean isSetupMode;
    private String extend;
    private String extendFilter;
    private String appName;
    private String appGroup;
    private String appTitle;
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public SolonProps() {
        super(System.getProperties());
    }

    public SolonProps load(Class<?> source, NvMap args) {
        String drift;
        this.args = args;
        this.source = source;
        this.sourceLocation = source.getProtectionDomain().getCodeSource().getLocation();
        this.loadAdd(Utils.getResource("application.properties"));
        this.loadAdd(Utils.getResource("application.yml"));
        String active = (String)args.get("active");
        if (Utils.isEmpty(active)) {
            active = this.get("solon.profiles.active");
        }
        if (Utils.isNotEmpty(active)) {
            this.loadAdd(Utils.getResource("application-" + active + ".properties"));
            this.loadAdd(Utils.getResource("application-" + active + ".yml"));
        }
        this.args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        this.isDebugMode = this.argx().getInt("debug") == 1;
        this.isSetupMode = this.argx().getInt("setup") == 1;
        this.isWhiteMode = this.argx().getInt("white", 1) == 1;
        boolean bl = this.isFilesMode = !this.sourceLocation.getPath().endsWith(".jar") && !this.sourceLocation.getPath().contains(".jar!/") && !this.sourceLocation.getPath().endsWith(".zip") && !this.sourceLocation.getPath().contains(".zip!/");
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        if (Utils.isEmpty(drift = (String)this.args.get("drift"))) {
            drift = this.get("solon.drift");
        }
        this.isDriftMode = "1".equals(drift);
        this.extend = (String)this.args.get("extend");
        if (Utils.isEmpty(this.extend)) {
            this.extend = this.get("solon.extend");
        }
        this.extendFilter = (String)this.args.get("extend.filter");
        if (Utils.isEmpty(this.extendFilter)) {
            this.extendFilter = this.get("solon.extend.filter");
        }
        this.appName = (String)this.args.get("app.name");
        if (Utils.isEmpty(this.appName)) {
            this.appName = this.get("solon.app.name");
        }
        this.appGroup = (String)this.args.get("app.group");
        if (Utils.isEmpty(this.appGroup)) {
            this.appGroup = this.get("solon.app.group");
        }
        this.appTitle = (String)this.args.get("app.title");
        if (Utils.isEmpty(this.appTitle)) {
            this.appTitle = this.get("solon.app.title");
        }
        return this;
    }

    public SolonProps loadAdd(URL url) {
        if (url != null) {
            Properties props = Utils.loadProperties(url);
            this.loadAdd(props);
        }
        return this;
    }

    public SolonProps loadAdd(String url) {
        return this.loadAdd(Utils.getResource(url));
    }

    public SolonProps loadAdd(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> kv : props.entrySet()) {
                String tmpV;
                Object v1 = kv.getValue();
                if (v1 instanceof String && (tmpV = (String)v1).startsWith("${") && tmpV.endsWith("}")) {
                    String tmpK = tmpV.substring(2, tmpV.length() - 1);
                    if ((tmpV = props.getProperty(tmpK)) == null) {
                        tmpV = this.getProperty(tmpK);
                    }
                    v1 = tmpV;
                }
                this.put(kv.getKey(), v1);
                System.getProperties().put(kv.getKey(), v1);
            }
        }
        return this;
    }

    protected void plugsScan(List<ClassLoader> classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            ResourceScaner.scan(classLoader, "solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(classLoader, k)).forEach((? super T url) -> this.plugsScanMapDo(classLoader, (URL)url));
            ResourceScaner.scan(classLoader, "META-INF/solon", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(classLoader, k)).forEach((? super T url) -> this.plugsScanMapDo(classLoader, (URL)url));
        }
        this.plugsSort();
    }

    private void plugsScanMapDo(ClassLoader classLoader, URL url) {
        try {
            Props p = new Props(Utils.loadProperties(url));
            String clzName = p.get("solon.plugin");
            if (!Utils.isEmpty(clzName)) {
                PluginEntity ent = new PluginEntity(classLoader, clzName);
                ent.priority = p.getInt("solon.plugin.priority", 0);
                this.plugs.add(ent);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public Class<?> source() {
        return this.source;
    }

    public URL sourceLocation() {
        return this.sourceLocation;
    }

    public NvMap argx() {
        return this.args;
    }

    public List<PluginEntity> plugs() {
        return this.plugs;
    }

    public void plugsSort() {
        if (this.plugs.size() > 0) {
            this.plugs.sort(Comparator.comparingInt(PluginEntity::getPriority).reversed());
        }
    }

    public int serverPort() {
        return this.getInt("server.port", 8080);
    }

    public String extend() {
        return this.extend;
    }

    public String extendFilter() {
        return this.extendFilter;
    }

    public String appName() {
        return this.appName;
    }

    public String appGroup() {
        return this.appGroup;
    }

    public String appTitle() {
        return this.appTitle;
    }

    public String version() {
        return "1.3.23";
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isSetupMode() {
        return this.isSetupMode;
    }

    public boolean isFilesMode() {
        return this.isFilesMode;
    }

    public void isFilesMode(boolean isFilesMode) {
        this.isFilesMode = isFilesMode;
    }

    public boolean isDriftMode() {
        return this.isDriftMode;
    }

    public void isDriftMode(boolean isDriftMode) {
        this.isDriftMode = isDriftMode;
    }

    public boolean isWhiteMode() {
        return this.isWhiteMode;
    }

    public void isWhiteMode(boolean isWhiteMode) {
        this.isWhiteMode = isWhiteMode;
    }
}

