/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PropsLoader;
import org.noear.solon.core.util.PrintUtil;

public class ExtendLoader {
    private static final ExtendLoader instance = new ExtendLoader();
    private static String path;

    public static String path() {
        return path;
    }

    public static void load(String extend, boolean autoMake) {
        ExtendLoader.load(extend, autoMake, null);
    }

    public static void load(String extend, boolean autoMake, Predicate<String> filter) {
        if (Utils.isNotEmpty(extend)) {
            if (extend.startsWith("!")) {
                extend = extend.substring(1);
                autoMake = true;
            }
            if ((extend = Utils.buildExt(extend, autoMake)) != null) {
                path = extend;
                PrintUtil.blueln("solon.extend: " + path);
                instance.loadFile(new File(path), filter);
            }
        }
    }

    public static boolean loadJar(File file) {
        try {
            JarClassLoader.global().loadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean unloadJar(File file) {
        try {
            JarClassLoader.global().unloadJar(file.toURI().toURL());
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private ExtendLoader() {
    }

    private void loadFile(File file, Predicate<String> filter) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loadFileDo(tmp, filter);
            }
        } else {
            this.loadFileDo(file, filter);
        }
    }

    private void loadFileDo(File file, Predicate<String> filter) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            if (filter != null && !filter.test(path)) {
                return;
            }
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    ExtendLoader.loadJar(file);
                    return;
                }
                if (path.endsWith(".properties")) {
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!PropsLoader.global().isSupport(path)) {
                        throw new RuntimeException("Do not support the *.yml");
                    }
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

