/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.Serializable;
import org.noear.solon.annotation.Note;

public class Result<T>
implements Serializable {
    private static final Result SUCCEED = new XResultReadonly<Object>(null);
    private static final Result FAILURE = new XResultReadonly(0, "");
    private int code;
    private String description;
    private T data;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public Result(T data) {
        this.code = 1;
        this.description = "";
        this.data = data;
    }

    public Result(int code, String description) {
        this.code = code;
        this.description = description;
    }

    @Note(value="\u6210\u529f\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> succeed() {
        return SUCCEED;
    }

    @Note(value="\u6210\u529f\u7684\u7ed3\u679c")
    public static <T> Result<T> succeed(T data) {
        return new Result<T>(data);
    }

    @Note(value="\u5931\u8d25\u7684\u7a7a\u7ed3\u679c")
    public static <T> Result<T> failure() {
        return FAILURE;
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code) {
        return Result.failure(code, "");
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(int code, String description) {
        return new Result<T>(code, description);
    }

    @Note(value="\u5931\u8d25\u7684\u7ed3\u679c")
    public static <T> Result<T> failure(String description) {
        return new Result<T>(0, description);
    }

    static class XResultReadonly<T>
    extends Result<T> {
        public XResultReadonly(T data) {
            super(data);
        }

        public XResultReadonly(int code, String description) {
            super(code, description);
        }

        @Override
        public void setCode(int code) {
            throw new RuntimeException("Thes result is readonly!");
        }

        @Override
        public void setData(T data) {
            throw new RuntimeException("Thes result is readonly!");
        }

        @Override
        public void setDescription(String description) {
            throw new RuntimeException("Thes result is readonly!");
        }
    }
}

