/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.route.RouteTable;

public class Router {
    private final RouteTable<Handler>[] routesH = new RouteTable[3];
    private final RouteTable<Listener> routesL;

    public Router() {
        this.routesH[0] = new RouteTable();
        this.routesH[1] = new RouteTable();
        this.routesH[2] = new RouteTable();
        this.routesL = new RouteTable();
    }

    public void add(String path, Handler handler) {
        this.add(path, Endpoint.main, MethodType.HTTP, handler);
    }

    public void add(String path, Endpoint endpoint, MethodType method, Handler handler) {
        this.add(path, endpoint, method, 0, handler);
    }

    public void add(String path, Endpoint endpoint, MethodType method, int index, Handler handler) {
        this.routesH[endpoint.code].add(new RouteTable.Route<Handler>(path, method, index, handler));
    }

    public void add(String path, Listener listener) {
        this.add(path, MethodType.ALL, listener);
    }

    public void add(String path, MethodType method, Listener listener) {
        this.add(path, method, 0, listener);
    }

    public void add(String path, MethodType method, int index, Listener listener) {
        this.routesL.add(new RouteTable.Route<Listener>(path, method, index, listener));
    }

    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
        this.routesL.clear();
    }

    public Handler matchOne(Context context, Endpoint endpoint) {
        String path = context.path();
        MethodType method = MethodType.valueOf(context.method());
        return this.routesH[endpoint.code].matchOne(path, method);
    }

    public List<Handler> matchAll(Context context, Endpoint endpoint) {
        String path = context.path();
        MethodType method = MethodType.valueOf(context.method());
        return this.routesH[endpoint.code].matchAll(path, method);
    }

    public Listener matchOne(Session session) {
        String path = session.path();
        return this.routesL.matchOne(path, session.method());
    }
}

