/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Function;

public class Message {
    private final int flag;
    private final String key;
    private final String resourceDescriptor;
    private final String header;
    private final byte[] body;
    private Charset charset = StandardCharsets.UTF_8;
    private boolean _handled;

    public int flag() {
        return this.flag;
    }

    public String key() {
        return this.key;
    }

    public String resourceDescriptor() {
        return this.resourceDescriptor;
    }

    public String header() {
        return this.header;
    }

    public byte[] body() {
        return this.body;
    }

    public <T> T map(Function<Message, T> mapper) {
        return mapper.apply(this);
    }

    private Message(int flag, String key, String resourceDescriptor, String header, byte[] body) {
        this.flag = flag;
        this.key = key == null ? "" : key;
        this.resourceDescriptor = resourceDescriptor == null ? "" : resourceDescriptor;
        this.header = header == null ? "" : header;
        this.body = body;
    }

    public String toString() {
        if (this.body == null) {
            return null;
        }
        return new String(this.body, this.charset);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public boolean getHandled() {
        return this._handled;
    }

    public static Message wrap(byte[] body) {
        return Message.wrap(null, null, body);
    }

    public static Message wrapJson(String resourceDescriptor, byte[] body) {
        return Message.wrap(resourceDescriptor, "Content-Type=application/json", body);
    }

    public static Message wrap(String resourceDescriptor, String header, byte[] body) {
        return Message.wrap(0, UUID.randomUUID().toString(), resourceDescriptor, header, body);
    }

    public static Message wrap(String key, String resourceDescriptor, String header, byte[] body) {
        return Message.wrap(0, key, resourceDescriptor, header, body);
    }

    public static Message wrap(int flag, String key, String resourceDescriptor, String header, byte[] body) {
        return new Message(flag, key, resourceDescriptor, header, body);
    }
}

