/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.ext.ConsumerEx;

public class HandlerLoader
extends HandlerAide {
    protected BeanWrap bw;
    protected Render bRender;
    protected Mapping bMapping;
    protected String bPath;
    protected boolean bRemoting;
    protected boolean allowMapping;

    public HandlerLoader(BeanWrap wrap) {
        this.bMapping = wrap.clz().getAnnotation(Mapping.class);
        if (this.bMapping == null) {
            this.initDo(wrap, null, wrap.remoting(), null, true);
        } else {
            this.initDo(wrap, this.bMapping.value(), wrap.remoting(), null, true);
        }
    }

    public HandlerLoader(BeanWrap wrap, String mapping) {
        this.initDo(wrap, mapping, wrap.remoting(), null, true);
    }

    public HandlerLoader(BeanWrap wrap, String mapping, boolean remoting) {
        this.initDo(wrap, mapping, remoting, null, true);
    }

    public HandlerLoader(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        this.initDo(wrap, mapping, remoting, render, allowMapping);
    }

    private void initDo(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        this.bw = wrap;
        this.bRender = render;
        this.allowMapping = allowMapping;
        if (mapping != null) {
            this.bPath = mapping;
        }
        this.bRemoting = remoting;
    }

    public String mapping() {
        return this.bPath;
    }

    public void load(HandlerSlots slots) {
        this.load(this.bRemoting, slots);
    }

    public void load(boolean all, HandlerSlots slots) {
        if (Handler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActionDo(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(HandlerSlots slots) {
        if (this.bMapping == null) {
            throw new RuntimeException(this.bw.clz().getName() + " No @XMapping!");
        }
        Handler handler = (Handler)this.bw.raw();
        slots.add(this.bMapping, handler);
    }

    protected void loadActionDo(HandlerSlots slots, boolean all) {
        if (this.bPath == null) {
            this.bPath = "";
        }
        this.loadControllerAide();
        int m_index = 0;
        for (Method method : this.bw.clz().getDeclaredMethods()) {
            MethodType[] m_method;
            String m_path;
            Mapping m_map = method.getAnnotation(Mapping.class);
            m_index = 0;
            if (m_map != null) {
                m_path = m_map.value();
                m_method = m_map.method();
                m_index = m_map.index();
            } else {
                m_path = method.getName();
                m_method = this.bMapping == null ? new MethodType[]{MethodType.HTTP} : this.bMapping.method();
            }
            if (m_map == null && !all) continue;
            String newPath = Utils.mergePath(this.bPath, m_path);
            Action action = this.createAction(this.bw, method, m_map, newPath, this.bRemoting);
            this.loadActionAide(method, action);
            for (MethodType m1 : m_method) {
                if (m_map == null) {
                    slots.add(newPath, m1, action);
                    continue;
                }
                if (m_map.after() || m_map.before()) {
                    if (m_map.after()) {
                        slots.after(newPath, m1, m_index, action);
                        continue;
                    }
                    slots.before(newPath, m1, m_index, action);
                    continue;
                }
                slots.add(newPath, m1, action);
            }
        }
    }

    protected void loadControllerAide() {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (anno instanceof Before) {
                HandlerLoader.addDo(((Before)anno).value(), b -> this.before((Handler)Aop.get(b)));
                continue;
            }
            if (anno instanceof After) {
                HandlerLoader.addDo(((After)anno).value(), f -> this.after((Handler)Aop.get(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    HandlerLoader.addDo(((Before)anno2).value(), b -> this.before((Handler)Aop.get(b)));
                    continue;
                }
                if (!(anno2 instanceof After)) continue;
                HandlerLoader.addDo(((After)anno2).value(), f -> this.after((Handler)Aop.get(f)));
            }
        }
    }

    protected void loadActionAide(Method method, Action action) {
        for (Annotation anno : method.getAnnotations()) {
            if (anno instanceof Before) {
                HandlerLoader.addDo(((Before)anno).value(), b -> action.before((Handler)Aop.get(b)));
                continue;
            }
            if (anno instanceof After) {
                HandlerLoader.addDo(((After)anno).value(), f -> action.after((Handler)Aop.get(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    HandlerLoader.addDo(((Before)anno2).value(), b -> action.before((Handler)Aop.get(b)));
                    continue;
                }
                if (!(anno2 instanceof After)) continue;
                HandlerLoader.addDo(((After)anno2).value(), f -> action.after((Handler)Aop.get(f)));
            }
        }
    }

    protected Action createAction(BeanWrap bw, Method method, Mapping mp, String path, boolean remoting) {
        if (this.allowMapping) {
            return new Action(bw, this, method, mp, path, remoting, this.bRender);
        }
        return new Action(bw, this, method, null, path, remoting, this.bRender);
    }

    private static <T> void addDo(T[] ary, ConsumerEx<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.accept(t);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

