/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;

public class Solon {
    private static int stopDelay = 10;
    private static SolonApp app;
    private static SolonApp appMain;
    private static String encoding;

    @Deprecated
    public static SolonApp global() {
        return app;
    }

    public static SolonApp app() {
        return app;
    }

    public static AopContext context() {
        if (app == null) {
            return null;
        }
        return app.context();
    }

    public static SolonProps cfg() {
        return Solon.app().cfg();
    }

    public static String encoding() {
        return encoding;
    }

    public static void encodingSet(String charset) {
        if (app == null && Utils.isNotEmpty(charset)) {
            encoding = charset;
        }
    }

    public static void startIsolatedApp(SolonApp isolatedApp, ConsumerEx<SolonApp> initialize) throws Throwable {
        app = isolatedApp;
        isolatedApp.start(initialize);
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        if (appMain != null) {
            app = appMain;
            return appMain;
        }
        if (Utils.isNotEmpty(encoding)) {
            System.setProperty("file.encoding", encoding);
        }
        System.getProperties().putIfAbsent("java.awt.headless", "true");
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        String pid = rb.getName().split("@")[0];
        System.setProperty("PID", pid);
        JarClassLoader.bindingThread();
        LogUtil.global().info("App: Start loading");
        try {
            app = appMain = new SolonApp(source, argx);
            app.start(initialize);
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            EventBus.push(e);
            if (!app.enableErrorAutoprint()) {
                e.printStackTrace();
            }
            Solon.stop0(true, 0);
            return null;
        }
        stopDelay = Solon.cfg().getInt("solon.stop.delay", 10);
        if (app.enableSafeStop()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, stopDelay)));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, 0)));
        }
        LogUtil.global().info("App: End loading elapsed=" + app.elapsedTimes() + "ms pid=" + pid + " v=" + app.cfg().version());
        return app;
    }

    public static void stopDelaySet(int delay) {
        stopDelay = delay;
    }

    public static void stop() {
        Solon.stop(stopDelay);
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    private static void stop0(boolean exit, int delay) {
        if (Solon.app() == null) {
            return;
        }
        if (delay > 0) {
            String hint = "(1.prestop 2.delay 3.stop)";
            LogUtil.global().info("App: Security to stop: begin..." + hint);
            Solon.cfg().plugs().forEach(p -> p.prestop());
            LogUtil.global().info("App: Security to stop: 1 completed " + hint);
            int delay1 = (int)((double)delay * 0.2);
            int delay2 = delay - delay1;
            if (delay1 > 0) {
                Solon.sleep0(delay1);
            }
            Solon.app().stopped = true;
            if (delay2 > 0) {
                Solon.sleep0(delay2);
            }
            LogUtil.global().info("App: Security to stop: 2 completed " + hint);
            Solon.cfg().plugs().forEach(p -> p.stop());
            LogUtil.global().info("App: Security to stop: 3 completed " + hint);
        } else {
            Solon.cfg().plugs().forEach(p -> p.prestop());
            Solon.app().stopped = true;
            Solon.cfg().plugs().forEach(p -> p.stop());
        }
        if (exit) {
            System.exit(1);
        }
    }

    private static void sleep0(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        encoding = "utf-8";
    }
}

