/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Properties;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.util.ScanUtil;

public class PluginUtil {
    public static void scanPlugins(ClassLoader classLoader, String limitFile, Consumer<PluginEntity> consumer) {
        ScanUtil.scan(classLoader, "META-INF/solon", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> Utils.getResource(classLoader, k)).filter(url -> !Utils.isNotEmpty(limitFile) || url.toString().contains(limitFile)).forEach(url -> {
            Properties props = Utils.loadProperties(url);
            PluginUtil.findPlugins(classLoader, props, consumer);
        });
    }

    public static void findPlugins(ClassLoader classLoader, Properties props, Consumer<PluginEntity> consumer) {
        String pluginStr = props.getProperty("solon.plugin");
        if (Utils.isNotEmpty(pluginStr)) {
            String[] plugins;
            int priority = Integer.parseInt(props.getProperty("solon.plugin.priority", "0"));
            for (String clzName : plugins = pluginStr.trim().split(",")) {
                if (clzName.length() <= 0) continue;
                PluginEntity ent = new PluginEntity(classLoader, clzName.trim(), props);
                ent.setPriority(priority);
                consumer.accept(ent);
            }
        }
    }
}

