/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.PropsLoader;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.PrintUtil;

public class ExtendLoader {
    private static final ExtendLoader instance = new ExtendLoader();
    private static String path;

    public static String path() {
        return path;
    }

    public static List<ClassLoader> load(String extend) {
        return ExtendLoader.load(extend, false);
    }

    public static List<ClassLoader> load(String extend, boolean autoMake) {
        return ExtendLoader.load(extend, autoMake, null);
    }

    public static List<ClassLoader> load(String extend, boolean autoMake, Predicate<String> filter) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(JarClassLoader.global());
        if (Utils.isNotEmpty(extend)) {
            if (extend.startsWith("!")) {
                extend = extend.substring(1);
                autoMake = true;
            }
            if ((extend = Utils.buildExt(extend, autoMake)) != null) {
                path = extend;
                PrintUtil.blueln("Extend: " + path);
                instance.loadFile(loaders, new File(path), filter);
            }
        }
        return loaders;
    }

    public static boolean loadJar(List<ClassLoader> loaders, File file) {
        try {
            if (Solon.app().enableJarIsolation() || file.getName().startsWith("!")) {
                loaders.add(JarClassLoader.loadJar(file));
            } else {
                JarClassLoader.global().addJar(file);
            }
            return true;
        }
        catch (Throwable ex) {
            EventBus.push(ex);
            return false;
        }
    }

    public static boolean loadJar(File file) {
        try {
            JarClassLoader.global().addJar(file);
            return true;
        }
        catch (Throwable ex) {
            EventBus.push(ex);
            return false;
        }
    }

    public static boolean unloadJar(File file) {
        try {
            JarClassLoader.global().removeJar(file);
            return true;
        }
        catch (Throwable ex) {
            EventBus.push(ex);
            return false;
        }
    }

    private ExtendLoader() {
    }

    private void loadFile(List<ClassLoader> loaders, File file, Predicate<String> filter) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loadFileDo(loaders, tmp, filter);
            }
        } else {
            this.loadFileDo(loaders, file, filter);
        }
    }

    private void loadFileDo(List<ClassLoader> loaders, File file, Predicate<String> filter) {
        if (file.isFile()) {
            String path = file.getAbsolutePath();
            if (filter != null && !filter.test(path)) {
                return;
            }
            try {
                if (path.endsWith(".jar") || path.endsWith(".zip")) {
                    ExtendLoader.loadJar(loaders, file);
                    return;
                }
                if (path.endsWith(".properties")) {
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
                if (path.endsWith(".yml")) {
                    if (!PropsLoader.global().isSupport(path)) {
                        throw new IllegalStateException("Do not support the *.yml");
                    }
                    Solon.cfg().loadAdd(file.toURI().toURL());
                    PrintUtil.blueln("loaded: " + path);
                    return;
                }
            }
            catch (Throwable ex) {
                EventBus.push(ex);
            }
        }
    }
}

