/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.PrintUtil;

public class RenderManager
implements Render {
    private static final Map<String, Render> _mapping = new HashMap<String, Render>();
    private static final Map<String, Render> _lib = new HashMap<String, Render>();
    private static Render _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    public static Render global = new RenderManager();

    private RenderManager() {
    }

    public static Render get(String name) {
        Render tmp = _lib.get(name);
        if (tmp == null) {
            tmp = _mapping.get(name);
        }
        return tmp;
    }

    public static void register(Render render) {
        if (render == null) {
            return;
        }
        _def = render;
        _lib.put(render.getClass().getSimpleName(), render);
        _lib.put(render.getClass().getName(), render);
        PrintUtil.info("View: load: " + render.getClass().getSimpleName());
        PrintUtil.info("View: load: " + render.getClass().getName());
    }

    public static void mapping(String suffix, Render render) {
        if (suffix == null || render == null) {
            return;
        }
        _mapping.put(suffix, render);
        PrintUtil.info("View: mapping: " + suffix + "=" + render.getName());
    }

    public static void mapping(String suffix, String clzName) {
        if (suffix == null || clzName == null) {
            return;
        }
        Render render = _lib.get(clzName);
        if (render == null) {
            PrintUtil.warn("solon: " + clzName + " not exists!");
            return;
        }
        _mapping.put(suffix, render);
        PrintUtil.info("View: mapping: " + suffix + "=" + clzName);
    }

    public static String renderAndReturn(ModelAndView modelAndView) {
        try {
            return global.renderAndReturn(modelAndView, Context.current());
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        Render render;
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                String suffix;
                Render render2;
                int suffix_idx = mv.view().lastIndexOf(".");
                if (suffix_idx > 0 && (render2 = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                    ctx.attrMap().forEach((k, v) -> mv.putIfAbsent((String)k, v));
                    return render2.renderAndReturn(mv, ctx);
                }
                return _def.renderAndReturn(mv, ctx);
            }
            data = mv.model();
        }
        if ((render = this.resolveRander(ctx)) != null) {
            return render.renderAndReturn(data, ctx);
        }
        return _def.renderAndReturn(data, ctx);
    }

    @Override
    public void render(Object data, Context ctx) throws Throwable {
        if (data instanceof DataThrowable) {
            return;
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (!Utils.isEmpty(mv.view())) {
                String suffix;
                Render render;
                int suffix_idx = mv.view().lastIndexOf(".");
                if (suffix_idx > 0 && (render = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                    ctx.attrMap().forEach((k, v) -> mv.putIfAbsent((String)k, v));
                    render.render(mv, ctx);
                    return;
                }
                _def.render(mv, ctx);
                return;
            }
            data = mv.model();
        }
        if (data instanceof File) {
            ctx.outputAsFile((File)((Object)data));
            return;
        }
        if (data instanceof DownloadedFile) {
            ctx.outputAsFile((DownloadedFile)((Object)data));
            return;
        }
        if (data instanceof InputStream) {
            ctx.output((InputStream)((Object)data));
            return;
        }
        Render render = this.resolveRander(ctx);
        if (render != null) {
            render.render(data, ctx);
        } else {
            _def.render(data, ctx);
        }
    }

    private Render resolveRander(Context ctx) {
        Render render = null;
        String mode = ctx.header("X-Serialization");
        if (Utils.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!Utils.isEmpty(mode) && (render = _mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null && ctx.remoting()) {
            render = _mapping.get("@type_json");
        }
        if (render == null) {
            render = _mapping.get("@json");
        }
        return render;
    }
}

