/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.List;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XEndpoint;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRouteTable;
import org.noear.solon.core.XSession;

public class XRouter {
    private final XRouteTable<XHandler>[] routesH = new XRouteTable[3];
    private final XRouteTable<XListener> routesL;

    public XRouter() {
        this.routesH[0] = new XRouteTable();
        this.routesH[1] = new XRouteTable();
        this.routesH[2] = new XRouteTable();
        this.routesL = new XRouteTable();
    }

    public void add(String path, XHandler handler) {
        this.add(path, XEndpoint.main, XMethod.HTTP, handler);
    }

    public void add(String path, XEndpoint endpoint, XMethod method, XHandler handler) {
        this.add(path, endpoint, method, 0, handler);
    }

    public void add(String path, XEndpoint endpoint, XMethod method, int index, XHandler handler) {
        this.routesH[endpoint.code].add(new XRouteTable.Route<XHandler>(path, method, index, handler));
    }

    public void add(String path, XListener listener) {
        this.add(path, XMethod.ALL, listener);
    }

    public void add(String path, XMethod method, XListener listener) {
        this.add(path, method, 0, listener);
    }

    public void add(String path, XMethod method, int index, XListener listener) {
        this.routesL.add(new XRouteTable.Route<XListener>(path, method, index, listener));
    }

    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
        this.routesL.clear();
    }

    public XHandler matchOne(XContext context, XEndpoint endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this.routesH[endpoint.code].matchOne(path, method);
    }

    public List<XHandler> matchAll(XContext context, XEndpoint endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this.routesH[endpoint.code].matchAll(path, method);
    }

    public XListener matchOne(XSession session) {
        String path = session.path();
        return this.routesL.matchOne(path, session.method());
    }
}

