/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XBridge;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerAide;
import org.noear.solon.core.XRender;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.ext.DataThrowable;
import org.noear.solon.ext.RunnableEx;

public class XAction
extends XHandlerAide
implements XHandler {
    private final BeanWrap bWrap;
    private final XHandlerAide bAide;
    private XRender bRender;
    private final boolean mIsMain;
    private final MethodWrap mWrap;
    private String mProduces;
    private final String mName;
    private final boolean mRemoting;
    private PathAnalyzer pathAnalyzer;
    private List<String> pathKeys;
    private static Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public XAction(BeanWrap bWrap, XHandlerAide bAide, Method method, XMapping mapping, String path, boolean remoting, XRender render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        this.mWrap = MethodWrap.get(method);
        this.mRemoting = remoting;
        this.bRender = render;
        if (this.bRender == null && XRender.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (XRender)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
            this.mIsMain = true;
        } else {
            this.mProduces = mapping.produces();
            this.mName = mapping.value();
            boolean bl = this.mIsMain = !mapping.after() && !mapping.before();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = new PathAnalyzer(path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public MethodWrap method() {
        return this.mWrap;
    }

    public BeanWrap bean() {
        return this.bWrap;
    }

    @Override
    public void handle(XContext x) throws Throwable {
        this.invoke(x, null);
    }

    public void invoke(XContext x, Object obj) throws Throwable {
        x.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get();
            }
            if (this.mIsMain) {
                x.attrSet("controller", obj);
                x.attrSet("action", this);
            }
            this.invoke0(x, obj);
        }
        catch (Throwable ex) {
            x.attrSet("error", ex);
            this.renderDo(ex, x);
            XEventBus.push(ex);
        }
    }

    protected void invoke0(XContext x, Object obj) throws Throwable {
        if (this.mIsMain) {
            this.handleDo(x, () -> {
                for (XHandler h : this.bAide.befores) {
                    h.handle(x);
                }
                for (XHandler h : this.befores) {
                    h.handle(x);
                }
            });
        }
        if (!x.getHandled()) {
            this.handleDo(x, () -> {
                Matcher pm;
                if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(x.path())).find()) {
                    int len = this.pathKeys.size();
                    for (int i = 0; i < len; ++i) {
                        x.paramSet(this.pathKeys.get(i), pm.group(i + 1));
                    }
                }
                Object tmp = this.callDo(x, obj, this.mWrap);
                if (this.mIsMain) {
                    x.result = tmp;
                    if (!XUtil.isEmpty(this.mProduces)) {
                        x.contentType(this.mProduces);
                    }
                    this.renderDo(tmp, x);
                }
            });
        }
        if (this.mIsMain) {
            for (XHandler h : this.bAide.afters) {
                h.handle(x);
            }
            for (XHandler h : this.afters) {
                h.handle(x);
            }
        }
    }

    protected void handleDo(XContext c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            c.setHandled(true);
            ex = XUtil.throwableUnwrap(ex);
            if (ex instanceof DataThrowable) {
                this.renderDo(ex, c);
            }
            c.attrSet("error", ex);
            this.renderDo(ex, c);
            XEventBus.push(ex);
        }
    }

    protected Object callDo(XContext ctx, Object obj, MethodWrap mWrap) throws Throwable {
        String ct = ctx.contentType();
        for (XActionExecutor me : XBridge.actionExecutors()) {
            if (!me.matched(ctx, ct)) continue;
            return me.execute(ctx, obj, mWrap);
        }
        return XBridge.actionExecutorDef().execute(ctx, obj, mWrap);
    }

    protected void renderDo(Object result, XContext x) throws Throwable {
        if (x.getRendered()) {
            return;
        }
        x.result = result;
        if (this.bRender == null) {
            x.setRendered(true);
            x.render(result);
        } else {
            this.bRender.render(result, x);
        }
    }
}

