/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.XApp;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XActionExecutorDefault;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRender;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XSessionState;
import org.noear.solon.core.XTranExecutor;
import org.noear.solon.core.XUpstream;

public class XBridge {
    private static XSessionState sessionState = new XSessionStateDefault();
    private static boolean sessionStateUpdated;
    private static XUpstream.Factory upstreamFactory;
    private static XActionExecutor actionExecutorDef;
    private static Set<XActionExecutor> actionExecutors;
    private static XTranExecutor tranExecutor;

    @XNote(value="\u8bbe\u7f6eSession\u72b6\u6001\u7ba1\u7406\u5668")
    public static void sessionStateSet(XSessionState ss) {
        if (ss != null) {
            sessionState = ss;
            if (!sessionStateUpdated) {
                sessionStateUpdated = true;
                XApp.global().before("**", XMethod.HTTP, c -> sessionState.sessionRefresh());
            }
        }
    }

    @XNote(value="\u83b7\u53d6Session\u72b6\u6001\u7ba1\u7406\u5668")
    public static XSessionState sessionState() {
        return sessionState;
    }

    @XNote(value="\u83b7\u53d6\u8d1f\u8f7d\u5de5\u5382")
    public static XUpstream.Factory upstreamFactory() {
        return upstreamFactory;
    }

    @XNote(value="\u8bbe\u7f6e\u8d1f\u8f7d\u5de5\u5382")
    public static void upstreamFactorySet(XUpstream.Factory uf) {
        if (uf != null) {
            upstreamFactory = uf;
        }
    }

    @XNote(value="\u83b7\u53d6\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static XActionExecutor actionExecutorDef() {
        return actionExecutorDef;
    }

    @XNote(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static void actionExecutorDefSet(XActionExecutor ae) {
        if (ae != null) {
            actionExecutorDef = ae;
        }
    }

    @XNote(value="\u83b7\u53d6\u6240\u6709Action\u6267\u884c\u5668")
    public static Set<XActionExecutor> actionExecutors() {
        return Collections.unmodifiableSet(actionExecutors);
    }

    @XNote(value="\u6dfb\u52a0Action\u6267\u884c\u5668")
    public static void actionExecutorAdd(XActionExecutor e) {
        if (e != null) {
            actionExecutors.add(e);
        }
    }

    @XNote(value="\u6ce8\u518c\u6e32\u67d3\u5668")
    public static void renderRegister(XRender render) {
        if (render != null) {
            XRenderManager.register(render);
        }
    }

    @XNote(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, XRender render) {
        if (suffix != null && render != null) {
            XRenderManager.mapping(suffix, render);
        }
    }

    @XNote(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, String className) {
        if (suffix != null && className != null) {
            XRenderManager.mapping(suffix, className);
        }
    }

    @XNote(value="\u83b7\u53d6\u4e8b\u52a1\u6267\u884c\u5668")
    public static XTranExecutor tranExecutor() {
        return tranExecutor;
    }

    @XNote(value="\u8bbe\u7f6e\u4e8b\u52a1\u6267\u884c\u5668")
    public static void tranExecutorSet(XTranExecutor te) {
        if (te != null) {
            tranExecutor = te;
        }
    }

    static {
        upstreamFactory = null;
        actionExecutorDef = new XActionExecutorDefault();
        actionExecutors = new HashSet<XActionExecutor>();
        tranExecutor = () -> false;
    }

    static class XSessionStateDefault
    implements XSessionState {
        XSessionStateDefault() {
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public Object sessionGet(String key) {
            return null;
        }

        @Override
        public void sessionSet(String key, Object val) {
        }
    }
}

