/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XProperties;
import org.noear.solon.core.util.ResourceScaner;

public final class XAppProperties
extends XProperties {
    private XMap args;
    private List<XPluginEntity> plugs = new ArrayList<XPluginEntity>();
    private boolean isDebugMode;
    private boolean isDriftMode;
    private boolean isFilesMode;
    private String extend;
    private String extendFilter;
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public XAppProperties() {
        super(System.getProperties());
    }

    public XAppProperties load(XMap args) {
        this.args = args;
        this.loadAdd(XUtil.getResource("application.properties"));
        this.loadAdd(XUtil.getResource("application.yml"));
        String active = this.get("solon.profiles.active");
        if (XUtil.isNotEmpty(active)) {
            this.loadAdd(XUtil.getResource("application-" + active + ".properties"));
            this.loadAdd(XUtil.getResource("application-" + active + ".yml"));
        }
        this.args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        this.isDebugMode = this.argx().getInt("debug") == 1;
        this.isDriftMode = this.argx().getInt("drift") == 1;
        this.isFilesMode = "file".equals(this.getClass().getProtectionDomain().getCodeSource().getLocation().getProtocol());
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        this.extend = (String)this.args.get("extend");
        if (XUtil.isEmpty(this.extend)) {
            this.extend = this.get("solon.extend");
        }
        this.extendFilter = (String)this.args.get("extend.filter");
        if (XUtil.isEmpty(this.extendFilter)) {
            this.extendFilter = this.get("solon.extend.filter");
        }
        return this;
    }

    public XAppProperties loadAdd(URL url) {
        Properties prop;
        if (url != null && (prop = XUtil.loadProperties(url)) != null) {
            this.putAll((Map<?, ?>)prop);
            System.getProperties().putAll((Map<?, ?>)prop);
        }
        return this;
    }

    public XAppProperties loadAdd(String url) {
        return this.loadAdd(XUtil.getResource(url));
    }

    protected void plugsScan() {
        ResourceScaner.scan("solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> XUtil.getResource(k)).forEach((? super T url) -> this.plugsScanMapDo((URL)url));
        ResourceScaner.scan("META-INF/solon", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> XUtil.getResource(k)).forEach((? super T url) -> this.plugsScanMapDo((URL)url));
        if (this.plugs.size() > 0) {
            this.plugs.sort(Comparator.comparingInt(XPluginEntity::getPriority).reversed());
        }
    }

    private void plugsScanMapDo(URL url) {
        try {
            XProperties p = new XProperties(XUtil.loadProperties(url));
            String temp = p.get("solon.plugin");
            if (!XUtil.isEmpty(temp)) {
                XPluginEntity ent = new XPluginEntity();
                ent.clzName = temp;
                ent.priority = p.getInt("solon.plugin.priority", 0);
                this.plugs.add(ent);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public XMap argx() {
        return this.args;
    }

    public List<XPluginEntity> plugs() {
        return this.plugs;
    }

    public int serverPort() {
        return this.getInt("server.port", 8080);
    }

    public String extend() {
        return this.extend;
    }

    public String extendFilter() {
        return this.extendFilter;
    }

    public String version() {
        return "1.1.13";
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public boolean isFilesMode() {
        return this.isFilesMode;
    }

    public boolean isDriftMode() {
        return this.isDriftMode;
    }
}

