/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopFactoryBase;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.VarHolderParam;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XMonitor;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XProperties;
import org.noear.solon.core.XScaner;
import org.noear.solon.core.utils.TypeUtil;

public class AopFactory
extends AopFactoryBase {
    public AopFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.beanCreatorAdd(XConfiguration.class, (clz, bw, anno) -> {
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.getMethod().getAnnotation(XBean.class);
                if (m_an == null) continue;
                AopFactory.beanBuild(m_an.value(), mWrap, bw, p1 -> {
                    XInject tmp = p1.getAnnotation(XInject.class);
                    if (tmp == null) {
                        return null;
                    }
                    return tmp.value();
                });
            }
        });
        this.beanCreatorAdd(XBean.class, (clz, bw, anno) -> this.beanAnnoHandle(bw, (XBean)anno));
        this.beanCreatorAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanCreatorAdd(XInterceptor.class, (clz, bw, anno) -> {
            BeanWebWrap bww = new BeanWebWrap(bw);
            bww.endpointSet(anno.after() ? 2 : 0);
            bww.load(XApp.global());
        });
        this.beanInjectorAdd(XInject.class, (fwT, anno) -> AopFactory.beanInject(fwT, anno.value()));
    }

    protected void beanAnnoHandle(BeanWrap bw, XBean anno) {
        bw.tagSet(anno.tag());
        if (XPlugin.class.isAssignableFrom(bw.clz())) {
            XApp.global().plug((XPlugin)bw.raw());
        } else {
            BeanWebWrap bww;
            bw.remotingSet(anno.remoting());
            this.beanRegister(bw, anno.value());
            if (bw.remoting() && (bww = new BeanWebWrap(bw)).mapping() != null) {
                bww.load(XApp.global());
            }
        }
    }

    public void beanRegister(BeanWrap bw, String name) {
        if (!XUtil.isEmpty(name)) {
            Aop.put(name, bw);
        } else {
            Class<?>[] list;
            Aop.put(bw.clz().getName(), bw);
            for (Class<?> c : list = bw.clz().getInterfaces()) {
                if (c.getName().contains("java.")) continue;
                this.clzMapping.put(c, bw.clz());
                this.beanNotice(c, bw);
            }
        }
    }

    @Override
    public BeanWrap wrap(Class<?> clz, Object raw) {
        BeanWrap l;
        BeanWrap bw = (BeanWrap)this.beanWraps.get(clz);
        if (bw == null && this.clzMapping.containsKey(clz)) {
            clz = (Class)this.clzMapping.get(clz);
            bw = (BeanWrap)this.beanWraps.get(clz);
        }
        if (bw == null && (l = this.beanWraps.putIfAbsent(clz, bw = new BeanWrap(clz, raw))) != null) {
            bw = l;
        }
        if (bw.raw() == null) {
            bw.rawSet(raw);
        }
        return bw;
    }

    public void inject(Object obj) {
        Field[] fs;
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Field f : fs = clzWrap.fields) {
            Annotation[] annS = f.getDeclaredAnnotations();
            if (annS.length <= 0) continue;
            VarHolder varH = clzWrap.getFieldWrap(f).holder(obj);
            this.tryBeanInject(varH, annS);
        }
    }

    public void put(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap get(String key) {
        return (BeanWrap)this.beans.get(key);
    }

    public void beanLoad(Class<?> source) {
        String dir = "";
        if (source.getPackage() != null) {
            dir = source.getPackage().getName().replace('.', '/');
        }
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return XUtil.loadClass(className.replace("/", "."));
        }).forEach(clz -> {
            Annotation[] annoSet;
            if (clz != null && (annoSet = clz.getDeclaredAnnotations()).length > 0) {
                try {
                    this.tryBeanCreate((Class<?>)clz, annoSet);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.loadedEvent.forEach(f -> f.run());
    }

    public static void beanBuild(String beanName, MethodWrap mWrap, BeanWrap bw, Function<Parameter, String> injectVal) throws Exception {
        int size2 = mWrap.getParameters().length;
        if (size2 == 0) {
            Object raw = mWrap.invoke(bw.raw(), new Object[0]);
            if (raw != null) {
                BeanWrap m_bw = new BeanWrap(raw.getClass(), raw);
                Aop.factory().beanRegister(m_bw, beanName);
            }
        } else {
            ArrayList args2 = new ArrayList(size2);
            ArrayList<VarHolderParam> args1 = new ArrayList<VarHolderParam>(size2);
            for (Parameter p1 : mWrap.getParameters()) {
                VarHolderParam p2 = new VarHolderParam(p1);
                args1.add(p2);
                AopFactory.beanInject(p2, injectVal.apply(p1));
            }
            XUtil.commonPool.submit(() -> {
                try {
                    for (VarHolderParam p2 : args1) {
                        args2.add(p2.getValue());
                    }
                    Object raw = mWrap.invoke(bw.raw(), args2.toArray());
                    if (raw != null) {
                        BeanWrap m_bw = new BeanWrap(raw.getClass(), raw);
                        Aop.factory().beanRegister(m_bw, beanName);
                    }
                }
                catch (Throwable ex) {
                    XMonitor.sendError(null, ex);
                }
                return true;
            });
        }
    }

    public static void beanInject(VarHolder varH, String name) {
        if (XUtil.isEmpty(name)) {
            Aop.getAsyn(varH.getType(), bw -> varH.setValue(bw.get()));
        } else if (!name.startsWith("${")) {
            Aop.getAsyn(name, bw -> varH.setValue(bw.get()));
        } else {
            name = name.substring(2, name.length() - 1);
            if (Properties.class == varH.getType()) {
                XProperties val = XApp.cfg().getProp(name);
                varH.setValue(val);
            } else if (Map.class == varH.getType()) {
                XMap val = XApp.cfg().getXmap(name);
                varH.setValue(val);
            } else {
                String val = XApp.cfg().get(name);
                if (val == null) {
                    Class<?> pt = varH.getType();
                    if (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive()) {
                        varH.setValue(null);
                    } else {
                        XProperties val0 = XApp.cfg().getProp(name);
                        Object val2 = ClassWrap.get(pt).newBy(val0::getProperty);
                        varH.setValue(val2);
                    }
                } else {
                    Object val2 = TypeUtil.changeOfPop(varH.getType(), val);
                    varH.setValue(val2);
                }
            }
        }
    }
}

