/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XProperties;
import org.noear.solon.core.XScaner;

public final class XAppProperties
extends XProperties {
    private XMap _args;
    private List<XPluginEntity> _plugs = new ArrayList<XPluginEntity>();
    private Set<BiConsumer<String, String>> _changeEvent = new HashSet<BiConsumer<String, String>>();

    public XAppProperties() {
        super(System.getProperties());
    }

    public XAppProperties load(XMap args) {
        this._args = args;
        this.load(XUtil.getResource("application.properties"));
        this.load(XUtil.getResource("application.yml"));
        this._args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
                System.setProperty(k, v);
            }
        });
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        return this;
    }

    public XAppProperties load(URL url) {
        Properties prop;
        if (url != null && (prop = XUtil.getProperties(url)) != null) {
            this.putAll((Map<?, ?>)prop);
            System.getProperties().putAll((Map<?, ?>)prop);
        }
        return this;
    }

    protected void plugsScan() {
        XScaner.scan("solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> XUtil.getResource(k)).forEach((? super T url) -> this.plugsScanMapDo((URL)url));
        if (this._plugs.size() > 0) {
            this._plugs.sort(Comparator.comparingInt(XPluginEntity::getPriority).reversed());
        }
    }

    private void plugsScanMapDo(URL url) {
        try {
            XAppProperties p = new XAppProperties().load(url);
            String temp = p.get("solon.plugin");
            if (!XUtil.isEmpty(temp)) {
                XPluginEntity ent = new XPluginEntity();
                ent.className = temp;
                ent.priority = p.getInt("solon.plugin.priority", 0);
                this._plugs.add(ent);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(BiConsumer<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        if (key instanceof String && value instanceof String) {
            this._changeEvent.forEach((? super T event) -> event.accept((String)key, (String)value));
        }
        return obj;
    }

    public XMap argx() {
        return this._args;
    }

    public List<XPluginEntity> plugs() {
        return this._plugs;
    }

    public int serverPort() {
        return this.getInt("server.port", 8080);
    }

    public boolean isDebugMode() {
        return this.argx().getInt("debug") == 1;
    }

    public boolean isDriftMode() {
        return this.argx().getInt("drift") == 1;
    }
}

