/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.solon.XAppProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XContextUtil;
import org.noear.solon.core.XEventHandler;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerSlots;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XMonitor;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XRouterHandler;
import org.noear.solon.ext.Act1;
import org.noear.solon.ext.Act1Ex;
import org.noear.solon.ext.Act2;
import org.noear.solon.ext.PrintUtil;

public class XApp
implements XHandler,
XHandlerSlots {
    private static XApp _global;
    private final Set<Act2<String, Object>> _onSharedAdd_event = new HashSet<Act2<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private final XRouter _router;
    private final int _port;
    private final XAppProperties _prop;
    private final Class<?> _source;
    private XHandler _handler = null;
    public boolean enableHttp = true;
    public boolean enableWebSocket = true;
    public boolean enableSocket = true;

    public static XApp global() {
        return _global;
    }

    public static XAppProperties cfg() {
        return XApp.global().prop();
    }

    public static XApp start(Class<?> source, String[] args) {
        return XApp.start(source, args, null);
    }

    public static XApp start(Class<?> source, String[] args, Act1Ex<XApp> builder) {
        XMap argx = XMap.from(args);
        return XApp.start(source, argx, builder);
    }

    public static XApp start(Class<?> source, XMap argx, Act1Ex<XApp> builder) {
        if (_global != null) {
            return _global;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> XApp.stopDo(false)));
        XClassLoader.bindingThread();
        long time_start = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: Start loading");
        _global = new XApp(source, argx);
        String _extend = (String)argx.get("extend");
        if (XUtil.isEmpty(_extend)) {
            _extend = _global.prop().get("solon.extend");
        }
        ExtendLoader.load(_extend);
        _global.prop().plugsScan();
        if (builder != null) {
            try {
                builder.run(_global);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        List<XPluginEntity> plugs = _global.prop().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        if (source != null) {
            _global.loadBean(source);
        }
        XMap map = _global.prop().getXmap("solon.view.mapping");
        map.forEach((k, v) -> XRenderManager.mapping("." + k, v));
        long time_end = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: End loading @" + (time_end - time_start) + "ms");
        return _global;
    }

    public static void stop() {
        XApp.stopDo(true);
    }

    private static void stopDo(boolean exit) {
        if (_global == null) {
            return;
        }
        _global.prop().plugs().forEach(p -> p.stop());
        _global = null;
        if (exit) {
            System.exit(0);
        }
    }

    public void loadBean(Class<?> source) {
        Aop.beanLoad(source);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.run(key, obj));
    }

    public <T> void sharedGet(String key, Act1<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.run(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.run(v);
                }
            });
        }
    }

    public void onSharedAdd(Act2<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public XRouter router() {
        return this._router;
    }

    protected XApp(Class<?> source, XMap args) {
        this._source = source;
        this._prop = new XAppProperties().load(args);
        this._port = this._prop.serverPort();
        this._router = new XRouter();
        this._handler = new XRouterHandler(this._router);
    }

    public Class<?> source() {
        return this._source;
    }

    public int port() {
        return this._port;
    }

    public XAppProperties prop() {
        return this._prop;
    }

    public void plug(XPlugin plugin) {
        XPluginEntity p = new XPluginEntity(plugin);
        p.start();
        this.prop().plugs().add(p);
    }

    public void before(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 0, method, handler);
    }

    @Override
    public void before(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 0, method, index, handler);
    }

    public void after(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 2, method, handler);
    }

    @Override
    public void after(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, 2, method, index, handler);
    }

    @Override
    public void add(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, 1, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = Aop.wrap(clz);
        if (bw != null) {
            new BeanWebWrap(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = Aop.wrap(clz);
        if (bw != null) {
            new BeanWebWrap(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, XHandler handler) {
        this.add(path, XMethod.ALL, handler);
    }

    public void http(String path, XHandler handler) {
        this.add(path, XMethod.HTTP, handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, XMethod.GET, handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, XMethod.POST, handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, XMethod.PUT, handler);
    }

    public void patch(String path, XHandler handler) {
        this.add(path, XMethod.PATCH, handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, XMethod.DELETE, handler);
    }

    public void ws(String path, XHandler handler) {
        this.add(path, XMethod.WEBSOCKET, handler);
    }

    public void socket(String path, XHandler handler) {
        this.add(path, XMethod.SOCKET, handler);
    }

    public XHandler handlerGet() {
        return this._handler;
    }

    public void handlerSet(XHandler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(XContext x) throws Throwable {
        try {
            XContextUtil.currentSet(x);
            this._handler.handle(x);
        }
        catch (Throwable ex) {
            XMonitor.sendError(x, ex);
            throw ex;
        }
        finally {
            XContextUtil.currentRemove();
        }
    }

    public void tryHandle(XContext x) {
        try {
            this.handle(x);
        }
        catch (Throwable ex) {
            x.status(500);
            x.setHandled(true);
            x.output(XUtil.getFullStackTrace(ex));
        }
    }

    public XApp onError(XEventHandler<Throwable> handler) {
        XMonitor.onError(handler);
        return this;
    }
}

