/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XProperties;
import org.noear.solon.core.XScaner;
import org.noear.solon.ext.Act2;

public final class XAppProperties
extends XProperties {
    public static final String server_port = "server.port";
    private XMap _args;
    private List<XPluginEntity> _plugs = new ArrayList<XPluginEntity>();
    private Set<Act2<String, String>> _changeEvent = new HashSet<Act2<String, String>>();

    public XAppProperties load(XMap args) {
        this._args = args;
        this.do_loadFile();
        this._args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
            }
        });
        if (this.isDebugMode()) {
            System.setProperty("debug", "1");
        }
        return this;
    }

    public XAppProperties load(URL url) {
        Properties prop;
        if (url != null && (prop = XUtil.getProperties(url)) != null) {
            this.putAll((Map<?, ?>)prop);
        }
        return this;
    }

    protected void plugsScan() {
        XScaner.scan("solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> XUtil.getResource(k)).forEach((? super T url) -> this.do_loadPlug((URL)url));
        if (this._plugs != null) {
            this._plugs.sort(Comparator.comparingInt(p1 -> p1.priority));
        }
    }

    private void do_loadFile() {
        this.load(XUtil.getResource("application.properties"));
        this.load(XUtil.getResource("application.yml"));
        Properties sys_prop = System.getProperties();
        HashMap _tmp = new HashMap();
        this.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (key.indexOf(".") > 0 && !sys_prop.containsKey(k)) {
                sys_prop.put(k, v);
                _tmp.put(key, k);
            }
        }));
        sys_prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (_tmp.containsKey(key)) {
                return;
            }
            if (key.startsWith("solon.") || key.indexOf("server.") >= 0) {
                this.setProperty(key, String.valueOf(v));
            }
        }));
    }

    private void do_loadPlug(URL url) {
        try {
            XAppProperties p = new XAppProperties().load(url);
            String temp = p.get("solon.plugin");
            if (!XUtil.isEmpty(temp)) {
                XPluginEntity ent = new XPluginEntity();
                ent.className = temp;
                ent.priority = -p.getInt("solon.plugin.priority", 0);
                this._plugs.add(ent);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(Act2<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Object obj = super.setProperty(key, value);
        this._changeEvent.forEach((? super T event) -> event.run(key, value));
        return obj;
    }

    public XMap argx() {
        return this._args;
    }

    public List<XPluginEntity> plugs() {
        return this._plugs;
    }

    public int serverPort() {
        return this.getInt(server_port, 8080);
    }

    public boolean isDebugMode() {
        return this.argx().getInt("debug") == 1;
    }
}

