/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.annotation.XAround;
import org.noear.solon.annotation.XCache;
import org.noear.solon.annotation.XCacheRemove;
import org.noear.solon.annotation.XTran;
import org.noear.solon.core.Aop;
import org.noear.solon.core.ValHolder;
import org.noear.solon.core.XBridge;

public class MethodWrap {
    private static Map<Method, MethodWrap> _cache = new ConcurrentHashMap<Method, MethodWrap>();
    private final XTran xTran;
    private final XCache xCache;
    private final XCacheRemove xCacheRemove;
    private final InvocationHandler xAround;
    private final Method method;
    private final Parameter[] parameters;
    private final Annotation[] annotations;

    public static MethodWrap get(Method method) {
        MethodWrap l;
        MethodWrap mw = _cache.get(method);
        if (mw == null && (l = _cache.putIfAbsent(method, mw = new MethodWrap(method))) != null) {
            mw = l;
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = m.getParameters();
        this.annotations = m.getAnnotations();
        this.xTran = m.getAnnotation(XTran.class);
        this.xCache = m.getAnnotation(XCache.class);
        this.xCacheRemove = m.getAnnotation(XCacheRemove.class);
        this.xAround = this.buildAround(m.getAnnotation(XAround.class));
    }

    private InvocationHandler buildAround(XAround anno) {
        if (anno == null) {
            return null;
        }
        return (InvocationHandler)Aop.get(anno.value());
    }

    public String getName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clz) {
        return this.method.getAnnotation(clz);
    }

    public Object invoke(Object obj, Object ... args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invokeByAspect(Object obj, Object ... args) throws Throwable {
        Object tmp = this.invokeByAspect0(obj, args);
        if (this.xCacheRemove != null) {
            XBridge.cacheExecutor().cacheRemove(this.xCacheRemove, this.method, this.parameters, args);
        }
        return tmp;
    }

    private Object invokeByAspect0(Object obj, Object ... args) throws Throwable {
        if (this.xCache == null) {
            return this.invokeByAspect1(obj, args);
        }
        return XBridge.cacheExecutor().cache(this.xCache, this.method, this.parameters, args, () -> this.invokeByAspect1(obj, args));
    }

    private Object invokeByAspect1(Object obj, Object ... args) throws Throwable {
        if (this.xTran == null) {
            return this.invokeByAspect2(obj, args);
        }
        ValHolder val0 = new ValHolder();
        XBridge.tranExecutor().execute(this.xTran, () -> {
            val0.value = this.invokeByAspect2(obj, args);
        });
        return val0.value;
    }

    private Object invokeByAspect2(Object obj, Object[] args) throws Throwable {
        if (this.xAround == null) {
            return this.method.invoke(obj, args);
        }
        return this.xAround.invoke(obj, this.method, args);
    }
}

