/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.utils;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XParam;
import org.noear.solon.core.XContext;

public class TypeUtil {
    private static final String date_def_format = "yyyy-MM-dd HH:mm:ss";

    public static Object changeOfCtx(AnnotatedElement p, Class<?> type, String key, String val, XContext ctx) {
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        Object rst = TypeUtil.do_change(type, val);
        if (rst != null) {
            return rst;
        }
        if (Date.class == type && p != null) {
            XParam xd = p.getAnnotation(XParam.class);
            String format = null;
            format = xd != null && !XUtil.isEmpty(xd.value()) ? xd.value() : date_def_format;
            SimpleDateFormat fm = new SimpleDateFormat(format);
            try {
                return fm.parse(val);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (type.isArray()) {
            String[] ary = ctx.paramValues(key);
            if (ary == null) {
                return null;
            }
            int len = ary.length;
            if (TypeUtil.is(String[].class, type)) {
                return ary;
            }
            if (TypeUtil.is(short[].class, type)) {
                short[] ary2 = new short[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Short.parseShort(ary[i]);
                }
                return ary2;
            }
            if (TypeUtil.is(int[].class, type)) {
                int[] ary2 = new int[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Integer.parseInt(ary[i]);
                }
                return ary2;
            }
            if (TypeUtil.is(long[].class, type)) {
                long[] ary2 = new long[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Long.parseLong(ary[i]);
                }
                return ary2;
            }
            if (TypeUtil.is(float[].class, type)) {
                float[] ary2 = new float[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Float.parseFloat(ary[i]);
                }
                return ary2;
            }
            if (TypeUtil.is(double[].class, type)) {
                double[] ary2 = new double[len];
                for (int i = 0; i < len; ++i) {
                    ary2[i] = Double.parseDouble(ary[i]);
                }
                return ary2;
            }
            if (TypeUtil.is(Object[].class, type)) {
                Class<?> c = type.getComponentType();
                Object[] ary2 = (Object[])Array.newInstance(c, len);
                for (int i = 0; i < len; ++i) {
                    ary2[i] = TypeUtil.do_change(c, ary[i]);
                }
                return ary2;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }

    private static boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }

    public static Object changeOfPop(Class<?> type, String val) {
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        Object rst = TypeUtil.do_change(type, val);
        if (rst != null) {
            return rst;
        }
        if (Date.class == type) {
            SimpleDateFormat fm = new SimpleDateFormat(date_def_format);
            try {
                return fm.parse(val);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }

    public static Object do_change(Class<?> type, String val) {
        if (Short.class == type || type == Short.TYPE) {
            return Short.parseShort(val);
        }
        if (Integer.class == type || type == Integer.TYPE) {
            return Integer.parseInt(val);
        }
        if (Long.class == type || type == Long.TYPE) {
            return Long.parseLong(val);
        }
        if (Double.class == type || type == Double.TYPE) {
            return Double.parseDouble(val);
        }
        if (Float.class == type || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Boolean.class == type || type == Boolean.TYPE) {
            return Boolean.parseBoolean(val);
        }
        if (LocalDate.class == type) {
            return LocalDate.parse(val);
        }
        if (LocalTime.class == type) {
            return LocalTime.parse(val);
        }
        if (LocalDateTime.class == type) {
            return LocalDateTime.parse(val);
        }
        return null;
    }
}

