/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.XActionUtil;
import org.noear.solon.core.XContextUtil;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XSessionState;
import org.noear.solon.core.XSessionStateDefault;

public abstract class XContext {
    private boolean _handled;
    private String _protocolAsUpper;
    private String _pathAsUpper;
    @XNote(value="SESSION_STATE\u5bf9\u8c61")
    private XSessionState _sessionState = XSessionStateDefault.global;
    private Map<String, Object> _attrMap = null;

    @XNote(value="\u83b7\u53d6\u5f53\u524d\u7ebf\u7a0b\u7684\u4e0a\u4e0b\u6587")
    public static XContext current() {
        return XContextUtil.current();
    }

    @XNote(value="\u8bbe\u7f6e\u5904\u7406\u72b6\u6001")
    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    @XNote(value="\u83b7\u53d6\u5904\u7406\u72b6\u6001")
    public boolean getHandled() {
        return this._handled;
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u5bf9\u8c61")
    public abstract Object request();

    @XNote(value="\u83b7\u53d6\u8fdc\u7a0bIP")
    public abstract String ip();

    @XNote(value="\u662f\u5426\u4e3a\u5206\u6bb5\u5185\u5bb9")
    public boolean isMultipart() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/");
    }

    @XNote(value="\u662f\u5426\u4e3a\u5206\u6bb5\u8868\u5355\u6570\u636e")
    public boolean isMultipartFormData() {
        String temp = this.contentType();
        if (temp == null) {
            return false;
        }
        return temp.toLowerCase().contains("multipart/form-data");
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u65b9\u6cd5")
    public abstract String method();

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u534f\u8bae")
    public abstract String protocol();

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u534f\u8bae\u5e76\u5927\u5199")
    public String protocolAsUpper() {
        if (this._protocolAsUpper == null) {
            this._protocolAsUpper = this.protocol().toUpperCase();
        }
        return this._protocolAsUpper;
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI")
    public abstract URI uri();

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84")
    public abstract String path();

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84\u53d8\u91cf,\u6839\u636e\u8def\u5f84\u8868\u8fbe\u5f0f")
    public XMap pathMap(String expr) {
        return XUtil.pathVarMap(this.path(), expr);
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684URI\u8def\u5f84\u5e76\u5927\u5199")
    public String pathAsUpper() {
        if (this._pathAsUpper == null) {
            this._pathAsUpper = this.path().toUpperCase();
        }
        return this._pathAsUpper;
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684UA")
    public String userAgent() {
        return this.header("User-Agent");
    }

    @XNote(value="\u83b7\u53d6\u8bf7\u6c42\u7684URL\u5b57\u7b26\u4e32")
    public abstract String url();

    @XNote(value="\u83b7\u53d6\u5185\u5bb9\u957f\u5ea6")
    public abstract long contentLength();

    @XNote(value="\u83b7\u53d6\u5185\u5bb9\u7c7b\u578b")
    public abstract String contentType();

    @XNote(value="\u83b7\u53d6RAW\u5185\u5bb9")
    public abstract String body() throws IOException;

    @XNote(value="\u83b7\u53d6RAW\u5185\u5bb9\u4e3aStream")
    public abstract InputStream bodyAsStream() throws IOException;

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u6570\u7ec4")
    public abstract String[] paramValues(String var1);

    @XNote(value="\u83b7\u53d6\u53c2\u6570")
    public abstract String param(String var1);

    @XNote(value="\u83b7\u53d6\u53c2\u6570")
    public abstract String param(String var1, String var2);

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aint")
    public abstract int paramAsInt(String var1);

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3aint")
    public int paramAsInt(String key, int def) {
        return Integer.parseInt(this.param(key, String.valueOf(def)));
    }

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3along")
    public abstract long paramAsLong(String var1);

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3along")
    public long paramAsLong(String key, long def) {
        return Long.parseLong(this.param(key, String.valueOf(def)));
    }

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3adouble")
    public abstract double paramAsDouble(String var1);

    @XNote(value="\u83b7\u53d6\u53c2\u6570\u5e76\u8f6c\u4e3adouble")
    public double paramAsDouble(String key, double def) {
        return Double.parseDouble(this.param(key, String.valueOf(def)));
    }

    @XNote(value="\u83b7\u53d6\u6240\u6709\u53c2\u6570\u5e76\u8f6c\u4e3amap")
    public abstract XMap paramMap();

    @XNote(value="\u8bbe\u7f6e\u53c2\u6570")
    public abstract void paramSet(String var1, String var2);

    @XNote(value="\u83b7\u53d6\u6240\u6709\u53c2\u6570\u5e76\u8f6c\u4e3aclass")
    public <T> T paramAsEntity(Class<T> clz) throws Exception {
        return (T)XActionUtil.params2Entity(this, clz);
    }

    @XNote(value="\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6")
    public abstract List<XFile> files(String var1) throws Exception;

    @XNote(value="\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6")
    public XFile file(String key) throws Exception {
        return XUtil.firstOrNull(this.files(key));
    }

    @XNote(value="\u83b7\u53d6COOKIE")
    public abstract String cookie(String var1);

    @XNote(value="\u83b7\u53d6COOKIE")
    public abstract String cookie(String var1, String var2);

    @XNote(value="\u83b7\u53d6\u6240\u6709COOKIE\u5e76\u8f6c\u4e3amap")
    public abstract XMap cookieMap();

    @XNote(value="\u83b7\u53d6HEADER")
    public abstract String header(String var1);

    @XNote(value="\u83b7\u53d6HEADER")
    public abstract String header(String var1, String var2);

    @XNote(value="\u83b7\u53d6\u6240\u6709HEADER\u5e76\u8f6c\u4e3amap")
    public abstract XMap headerMap();

    protected void sessionStateInit(XSessionState sessionState) {
        if (this._sessionState == null || this._sessionState.replaceable()) {
            this._sessionState = sessionState;
        }
    }

    @XNote(value="\u83b7\u53d6SESSION_ID")
    public final String sessionId() {
        return this._sessionState.sessionId();
    }

    @XNote(value="\u83b7\u53d6SESSION\u72b6\u6001")
    public final Object session(String key) {
        return this._sessionState.sessionGet(key);
    }

    @XNote(value="\u8bbe\u7f6eSESSION\u72b6\u6001")
    public final void sessionSet(String key, Object val) {
        this._sessionState.sessionSet(key, val);
    }

    @XNote(value="\u83b7\u53d6\u8f93\u51fa\u5bf9\u8c61")
    public abstract Object response();

    @XNote(value="\u8bbe\u7f6e\u5b57\u7b26\u96c6")
    public abstract void charset(String var1);

    @XNote(value="\u8bbe\u7f6e\u5185\u5bb9\u7c7b\u578b")
    public abstract void contentType(String var1);

    @XNote(value="\u8f93\u51fa\u5185\u5bb9:\u5b57\u7b26\u4e32")
    public abstract void output(String var1);

    @XNote(value="\u8f93\u51fa\u5185\u5bb9:\u5f02\u5e38\u5bf9\u8c61")
    public void output(Exception ex) {
        this.output(XUtil.getFullStackTrace(ex));
    }

    @XNote(value="\u8f93\u51fa\u5185\u5bb9:stream")
    public abstract void output(InputStream var1);

    @XNote(value="\u83b7\u53d6\u8f93\u51fa\u6d41")
    public abstract OutputStream outputStream() throws IOException;

    @XNote(value="\u8f93\u51fajson")
    public void outputAsJson(String json) {
        this.contentType("application/json;charset=utf-8");
        this.output(json);
    }

    @XNote(value="\u8f93\u51fahtml")
    public void outputAsHtml(String html) {
        this.contentType("text/html;charset=utf-8");
        if (!html.startsWith("<")) {
            StringBuilder sb = new StringBuilder();
            sb.append("<!doctype html>");
            sb.append("<html>");
            sb.append(html);
            sb.append("</html>");
            this.output(sb.toString());
        } else {
            this.output(html);
        }
    }

    @XNote(value="\u8bbe\u7f6eHEADER")
    public abstract void headerSet(String var1, String var2);

    @XNote(value="\u8bbe\u7f6eCOOKIE")
    public abstract void cookieSet(String var1, String var2, int var3);

    @XNote(value="\u8bbe\u7f6eCOOKIE")
    public abstract void cookieSet(String var1, String var2, String var3, int var4);

    @XNote(value="\u8bbe\u7f6eCOOKIE")
    public abstract void cookieSet(String var1, String var2, String var3, String var4, int var5);

    @XNote(value="\u79fb\u5f90COOKIE")
    public abstract void cookieRemove(String var1);

    @XNote(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1);

    @XNote(value="\u8df3\u8f6c\u5730\u5740")
    public abstract void redirect(String var1, int var2);

    @XNote(value="\u83b7\u53d6\u8f93\u51fa\u72b6\u6001")
    public abstract int status();

    @XNote(value="\u8bbe\u7f6e\u8f93\u51fa\u72b6\u6001")
    public abstract void status(int var1);

    private Map<String, Object> attrMap() {
        if (this._attrMap == null) {
            this._attrMap = new HashMap<String, Object>();
        }
        return this._attrMap;
    }

    @XNote(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u7279\u6027")
    public <T> T attr(String key, T def) {
        Object val = this.attrMap().get(key);
        if (val == null) {
            return def;
        }
        return (T)val;
    }

    @XNote(value="\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrSet(String key, Object val) {
        this.attrMap().put(key, val);
    }

    @XNote(value="\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrSet(Map<String, Object> map) {
        this.attrMap().putAll(map);
    }

    @XNote(value="\u6e05\u7a7a\u81ea\u5b9a\u4e49\u7279\u6027")
    public void attrClear() {
        this.attrMap().clear();
    }

    @XNote(value="\u6e32\u67d3\u6570\u636e")
    public void render(Object obj) throws Throwable {
        XRenderManager.global.render(obj, this);
    }
}

