/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.XApp;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XActionExecutorDefault;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRender;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XSessionState;
import org.noear.solon.core.XTranExecutor;
import org.noear.solon.core.XUpstreamFactory;

public class XBridge {
    private static XSessionState _sessionState = new XSessionStateDefault();
    private static boolean _sessionStateUpdated;
    private static XUpstreamFactory _upstreamFactory;
    private static XActionExecutor _actionExecutorDef;
    private static Set<XActionExecutor> _actionExecutors;
    private static XTranExecutor _tranExecutor;

    public static void sessionStateSet(XSessionState ss) {
        if (ss != null) {
            _sessionState = ss;
            if (!_sessionStateUpdated) {
                _sessionStateUpdated = true;
                XApp.global().before("**", XMethod.HTTP, c -> _sessionState.sessionRefresh());
            }
        }
    }

    public static XSessionState sessionState() {
        return _sessionState;
    }

    public static XUpstreamFactory upstreamFactory() {
        return _upstreamFactory;
    }

    public static void upstreamFactorySet(XUpstreamFactory uf) {
        if (uf != null) {
            _upstreamFactory = uf;
        }
    }

    public static XActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    public static void actionExecutorDefSet(XActionExecutor ae) {
        if (ae != null) {
            _actionExecutorDef = ae;
        }
    }

    public static Set<XActionExecutor> actionExecutors() {
        return Collections.unmodifiableSet(_actionExecutors);
    }

    public static void actionExecutorAdd(XActionExecutor e) {
        if (e != null) {
            _actionExecutors.add(e);
        }
    }

    public static void renderRegister(XRender render) {
        if (render != null) {
            XRenderManager.register(render);
        }
    }

    public static void renderMapping(String suffix, XRender render) {
        if (suffix != null && render != null) {
            XRenderManager.mapping(suffix, render);
        }
    }

    public static void renderMapping(String suffix, String className) {
        if (suffix != null && className != null) {
            XRenderManager.mapping(suffix, className);
        }
    }

    public static XTranExecutor tranExecutor() {
        return _tranExecutor;
    }

    public static void tranExecutorSet(XTranExecutor te) {
        if (te != null) {
            _tranExecutor = te;
        }
    }

    static {
        _upstreamFactory = service -> {
            throw new RuntimeException("Uninitialized upstreamFactory");
        };
        _actionExecutorDef = new XActionExecutorDefault();
        _actionExecutors = new HashSet<XActionExecutor>();
        _tranExecutor = (anno, runnable) -> runnable.run();
    }

    static class XSessionStateDefault
    implements XSessionState {
        XSessionStateDefault() {
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public Object sessionGet(String key) {
            return null;
        }

        @Override
        public void sessionSet(String key, Object val) {
        }
    }
}

