/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.core.XMap;

public class XUtil {
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public static String guid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static <T> T firstOrNull(List<T> list) {
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static String expCompile(String path) {
        String p = path;
        p = p.replace(".", "\\.");
        p = p.replace("$", "\\$");
        p = p.replace("**", ".+?");
        if ((p = p.replace("*", "[^/]+")).indexOf("{") >= 0) {
            p = p.replaceAll("\\{.+?\\}", "([^/]+?)");
        }
        if (!p.startsWith("/")) {
            p = "/" + p;
        }
        return "^" + p + "$";
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T newClass(String className) {
        try {
            Class<?> clz = Class.forName(className);
            return (T)clz.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = XUtil.class.getClassLoader().getResources(name);
        if (urls == null || !urls.hasMoreElements()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            urls = loader != null ? loader.getResources(name) : ClassLoader.getSystemResources(name);
        }
        return urls;
    }

    public static URL getResource(String name) {
        URL url = XUtil.class.getResource(name);
        if (url == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            url = loader != null ? loader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static String getFullStackTrace(Exception ex) {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.getBuffer().toString();
    }

    public static String mergePath(String path1, String path2) {
        if (XUtil.isEmpty(path1)) {
            if (path2.startsWith("/")) {
                return path2;
            }
            return "/" + path2;
        }
        if (!path1.startsWith("/")) {
            path1 = "/" + path1;
        }
        if (XUtil.isEmpty(path2)) {
            return path1;
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        if (path1.endsWith("/")) {
            return path1 + path2;
        }
        if (path1.endsWith("*")) {
            int idx = path1.lastIndexOf(47) + 1;
            if (idx < 1) {
                return path2;
            }
            return path1.substring(0, idx) + path2;
        }
        return path1 + "/" + path2;
    }

    public static XMap pathVarMap(String path, String expr) {
        XMap _map = new XMap();
        if (expr.indexOf("{") >= 0) {
            Pattern _pr;
            Matcher pm = _pkr.matcher(expr);
            ArrayList<String> _pks = new ArrayList<String>();
            while (pm.find()) {
                _pks.add(pm.group(1));
            }
            if (_pks.size() > 0 && (pm = (_pr = Pattern.compile(XUtil.expCompile(expr), 2)).matcher(path)).find()) {
                int len = _pks.size();
                for (int i = 0; i < len; ++i) {
                    _map.put(_pks.get(i), pm.group(i + 1));
                }
            }
        }
        return _map;
    }
}

