/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XBean;
import org.noear.solon.annotation.XConfiguration;
import org.noear.solon.annotation.XController;
import org.noear.solon.annotation.XEvent;
import org.noear.solon.annotation.XInject;
import org.noear.solon.annotation.XInterceptor;
import org.noear.solon.core.Aop;
import org.noear.solon.core.AopFactoryBase;
import org.noear.solon.core.BeanWebWrap;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XEventListener;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XScaner;

public class AopFactory
extends AopFactoryBase {
    public AopFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.beanCreatorAdd(XConfiguration.class, (clz, bw, anno) -> {
            for (MethodWrap mWrap : ClassWrap.get(bw.clz()).methodWraps) {
                XBean m_an = mWrap.getMethod().getAnnotation(XBean.class);
                if (m_an == null) continue;
                XInject beanInj = mWrap.getMethod().getAnnotation(XInject.class);
                this.tryBuildBean(m_an.value(), mWrap, bw, beanInj, p1 -> {
                    XInject tmp = p1.getAnnotation(XInject.class);
                    if (tmp == null) {
                        return null;
                    }
                    return tmp.value();
                });
            }
        });
        this.beanCreatorAdd(XBean.class, (clz, bw, anno) -> {
            bw.tagSet(anno.tag());
            if (XPlugin.class.isAssignableFrom(bw.clz())) {
                XApp.global().plug((XPlugin)bw.raw());
            } else {
                BeanWebWrap bww;
                bw.remotingSet(anno.remoting());
                this.beanRegister(bw, anno.value());
                if (bw.remoting() && (bww = new BeanWebWrap(bw)).mapping() != null) {
                    bww.load(XApp.global());
                }
            }
        });
        this.beanCreatorAdd(XController.class, (clz, bw, anno) -> new BeanWebWrap(bw).load(XApp.global()));
        this.beanCreatorAdd(XInterceptor.class, (clz, bw, anno) -> new BeanWebWrap(bw).main(false).load(XApp.global()));
        this.beanCreatorAdd(XEvent.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof XEventListener) {
                XEventBus.subscribe(anno.value(), (XEventListener)bw.raw());
            }
        });
        this.beanInjectorAdd(XInject.class, (fwT, anno) -> this.tryInjectByName(fwT, anno.value()));
    }

    public void beanLoad(Class<?> source, boolean loaded) {
        String dir = "";
        if (source.getPackage() != null) {
            dir = source.getPackage().getName().replace('.', '/');
        }
        XScaner.scan(dir, n -> n.endsWith(".class")).stream().map(name -> {
            String className = name.substring(0, name.length() - 6);
            return XUtil.loadClass(className.replace("/", "."));
        }).forEach(clz -> {
            if (clz != null) {
                this.tryCreateBean((Class<?>)clz);
            }
        });
        if (loaded) {
            this.loadedEvent.forEach(f -> f.run());
        }
    }

    public void beanRegister(BeanWrap bw, String name) {
        if (!XUtil.isEmpty(name)) {
            Aop.factory().putWrap(name, bw);
        } else {
            Class<?>[] list;
            Aop.factory().putWrap(bw.clz(), bw);
            Aop.factory().putWrap(bw.clz().getName(), bw);
            for (Class<?> c : list = bw.clz().getInterfaces()) {
                if (c.getName().contains("java.")) continue;
                this.clzMapping.putIfAbsent(c, bw.clz());
                Aop.factory().putWrap(c, bw);
            }
        }
    }

    public void beanInject(Object obj) {
        Field[] fs;
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        for (Field f : fs = clzWrap.fields) {
            Annotation[] annS = f.getDeclaredAnnotations();
            if (annS.length <= 0) continue;
            VarHolder varH = clzWrap.getFieldWrap(f).holder(obj);
            this.tryInject(varH, annS);
        }
    }
}

