/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Stack;
import org.noear.solon.annotation.XTran;
import org.noear.solon.core.Tran;
import org.noear.solon.core.TranEntity;
import org.noear.solon.core.TranFactory;
import org.noear.solon.core.TranPolicy;
import org.noear.solon.ext.RunnableEx;

public class TranManger {
    private static TranFactory factory;
    private static ThreadLocal<Stack<TranEntity>> local;

    public static void setFactory(TranFactory factory) {
        TranManger.factory = factory;
    }

    public static void execute(XTran anno, RunnableEx runnable) throws Throwable {
        if (anno == null || factory == null) {
            runnable.run();
            return;
        }
        Stack<TranEntity> stack = local.get();
        if (stack == null) {
            TranManger.forRoot(stack, anno, runnable);
        } else {
            TranManger.forNotRoot(stack, anno, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forRoot(Stack<TranEntity> stack, XTran anno, RunnableEx runnable) throws Throwable {
        if (anno.policy() == TranPolicy.supports || anno.policy() == TranPolicy.exclude || anno.policy() == TranPolicy.never) {
            runnable.run();
            return;
        }
        Tran tran = factory.create(anno);
        stack = new Stack();
        try {
            local.set(stack);
            TranManger.apply2(stack, tran, anno, runnable);
        }
        finally {
            local.remove();
        }
    }

    private static void forNotRoot(Stack<TranEntity> stack, XTran anno, RunnableEx runnable) throws Throwable {
        TranEntity before = stack.peek();
        if (anno.policy() == TranPolicy.supports) {
            if (anno.value().equals(before.anno.value()) || before.anno.group()) {
                runnable.run();
            } else {
                factory.createNot().apply(runnable);
            }
            return;
        }
        if (anno.policy() == TranPolicy.exclude || anno.policy() == TranPolicy.never) {
            factory.create(anno).apply(runnable);
            return;
        }
        if (anno.group() || anno.policy() == TranPolicy.requires_new) {
            Tran tran = factory.create(anno);
            TranManger.apply2(stack, tran, anno, runnable);
            return;
        }
        if (anno.policy() == TranPolicy.mandatory) {
            if (!anno.value().equals(before.anno.value())) {
                throw new RuntimeException("You must have the same source transaction");
            }
            Tran tran = factory.create(anno);
            tran.apply(runnable);
            return;
        }
        if (before.tran.isGroup()) {
            Tran tran = factory.create(anno);
            before.tran.add(tran);
            TranManger.apply2(stack, tran, anno, runnable);
            return;
        }
        if (before.anno.value().equals(anno.value()) && anno.policy() != TranPolicy.nested) {
            runnable.run();
        } else {
            Tran tran = factory.create(anno);
            TranManger.apply2(stack, tran, anno, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void apply2(Stack<TranEntity> stack, Tran tran, XTran anno, RunnableEx runnable) throws Throwable {
        if (anno.group() || anno.policy().code <= TranPolicy.nested.code) {
            try {
                stack.push(new TranEntity(tran, anno));
                tran.apply(runnable);
            }
            finally {
                stack.pop();
            }
        } else {
            tran.apply(runnable);
        }
    }

    static {
        local = new ThreadLocal();
    }
}

